@extends('admin.layouts.app')
@section('content')
    <div>
        <ul class="flex space-x-2 rtl:space-x-reverse">
            <li>
                <a href="{{ route('admin.dashboard') }}" class="text-primary hover:underline">Dashboard</a>
            </li>
            <li class="before:content-['/'] ltr:before:mr-1 rtl:before:ml-1">
                <span>Add Item</span>
            </li>
        </ul>
    </div>
    <div class="pt-5">
        <!-- Basic Details Section -->
        <div class="panel mb-4 border-t border-primary">
            <div class="mb-5 flex items-center justify-between">
                <h5 class="text-lg font-semibold dark:text-white-light">Basic Details</h5>
            </div>
            <form class="space-y-5">
                <div class="grid grid-cols-1 gap-4 sm:grid-cols-3">
                    <div>
                        <label for="itemRef">Item Ref</label>
                        <input id="itemRef" type="text" placeholder="Item Ref" class="form-input">
                    </div>
                    <div>
                        <label for="itemName">Name</label>
                        <input id="itemName" type="text" placeholder="Item Name" class="form-input">
                    </div>
                    <div>
                        <label for="itemNameE">Name (E)</label>
                        <input id="itemNameE" type="text" placeholder="Item Name (English)" class="form-input">
                    </div>
                    <div>
                        <label for="itemNameA">Name (A)</label>
                        <input id="itemNameA" type="text" placeholder="Item Name (Arabic)" class="form-input">
                    </div>
                    <div>
                        <label for="description">Description</label>
                        <input id="description" type="text" placeholder="Description" class="form-input">
                    </div>
                    <div>
                        <label for="shortDesc">Short</label>
                        <input id="shortDesc" type="text" placeholder="Short Description" class="form-input">
                    </div>
                    <div>
                        <label for="partNumber">Part Number</label>
                        <input id="partNumber" type="text" placeholder="Part Number" class="form-input">
                    </div>
                    <div>
                        <label for="itemGroup">Item Group</label>
                        <select id="itemGroup" class="form-select">
                            <option>Barcode Accessory</option>
                            <!-- Additional options can be added here -->
                        </select>
                    </div>
                    <div>
                        <label for="category">Category</label>
                        <select id="category" class="form-select">
                            <option>Access Controller</option>
                            <!-- Additional options can be added here -->
                        </select>
                    </div>
                    <div>
                        <label for="vendor">Vendor</label>
                        <select id="vendor" class="form-select">
                            <option>Acer</option>
                            <!-- Additional options can be added here -->
                        </select>
                    </div>
                    <div>
                        <label for="tag">Tag</label>
                        <input id="tag" type="text" placeholder="Tag" class="form-input">
                    </div>
                    <div class="col-span-3">
                        <label for="notes">Notes</label>
                        <textarea id="notes" placeholder="Enter ..." class="form-input"></textarea>
                    </div>
                </div>
                <div class="mb-5 flex items-center justify-start gap-2">
                    <button type="submit" class="btn btn-primary">Generate Part Number</button>
                    <h5 class="text-sm font-semibold dark:text-white-light">Generated Part Number :</h5>
                </div>
            </form>
        </div>

        <!-- Item Value Section -->
        <div class="panel mb-4 border-t border-primary">
            <div class="mb-5 flex items-center justify-between">
                <h5 class="text-lg font-semibold dark:text-white-light">Item Value</h5>
            </div>
            <form class="space-y-5">
                <div class="grid grid-cols-1 gap-4 sm:grid-cols-3">
                    <div>
                        <label for="purchasePrice">Purchase Price</label>
                        <div class="flex">
                            <button type="button" class="btn btn-info ltr:rounded-r-none rtl:rounded-l-none">$</button>
                            <input  id="purchasePrice" type="text"  class="form-input ltr:rounded-l-none rtl:rounded-r-none">
                            <button type="button" class="btn btn-outline-secondary ltr:rounded-l-none rtl:rounded-r-none">
                                .00
                            </button>
                        </div>
                    </div>
                    <div>
                        <label for="currencySell">Currency (Purch)</label>
                        <select id="currencySell" class="form-select">
                            <option>SAR</option>
                            <!-- Additional options can be added here -->
                        </select>
                    </div>
                    <div>
                        <label for="sellingPrice">Selling Price</label>
                        <div class="flex">
                            <button type="button" class="btn btn-info ltr:rounded-r-none rtl:rounded-l-none">$</button>
                            <input id="sellingPrice"  type="text"  class="form-input ltr:rounded-l-none rtl:rounded-r-none">
                            <button type="button" class="btn btn-outline-secondary ltr:rounded-l-none rtl:rounded-r-none">
                                .00
                            </button>
                        </div>
                    </div>
                    <div>
                        <label for="currencySell">Currency (Sell)</label>
                        <select id="currencySell" class="form-select">
                            <option>SAR</option>
                            <!-- Additional options can be added here -->
                        </select>
                    </div>
                    <div>
                        <label for="itemCost">Item Cost</label>
                        <div class="flex">
                            <button type="button" class="btn btn-info ltr:rounded-r-none rtl:rounded-l-none">$</button>
                            <input id="itemCost"  type="text"  class="form-input ltr:rounded-l-none rtl:rounded-r-none">
                            <button type="button" class="btn btn-outline-secondary ltr:rounded-l-none rtl:rounded-r-none">
                                .00
                            </button>
                        </div>
                    </div>
                </div>
            </form>
        </div>

        {{-- Inventory details  --}}
        <div class="panel mb-4 border-t border-primary">
            <div class="mb-5 flex items-center justify-between">
                <h5 class="text-lg font-semibold dark:text-white-light">Inventory Details</h5>
            </div>
            <form class="space-y-5">
                <div class="grid grid-cols-1 gap-4 sm:grid-cols-3">
                    <div>
                        <label for="UnitId">Unit Id</label>
                        <input id="UnitId" type="text" placeholder="Unit Id" class="form-input">
                    </div>
                    <div>
                        <label for="SalesUnit">Sales Unit</label>
                        <input id="SalesUnit" type="text" placeholder="Sales Unit" class="form-input">
                    </div>
                    <div>
                        <label for="PurchaseUnit">Purchase Unit</label>
                        <input id="PurchaseUnit" type="text" placeholder="Purchase Unit" class="form-input">
                    </div>
                    
                </div>
                <div class="flex justify-end">
                    <button type="submit" class="btn btn-primary">Submit</button>
                </div>
            </form>
        </div>
    </div>
@endsection
