@extends('admin.layouts.app')
@section('content')
    <div>
        <ul class="flex space-x-2 rtl:space-x-reverse">
            <li>
                <a href="{{ route('admin.dashboard') }}" class="text-primary hover:underline">Dashboard</a>
            </li>
            <li class="before:content-['/'] ltr:before:mr-1 rtl:before:ml-1">
                <span>Item List</span>
            </li>
        </ul>


        <div class="pt-5">



            <div class="panel">
                <!-- Transfer Header Section -->
                <div class="mb-5 flex items-center justify-between">
                    <h5 class="text-lg font-semibold dark:text-white-light">Item List</h5>
                </div>

                <div class="mb-5">
                    <div class="table-responsive">
                        <table>
                            <thead>
                                <tr>
                                    <th>Item ID</th>
                                    <th>Tag Number</th>
                                    <th>Item Ref</th>
                                    <th>Item Name</th>
                                    <th>Short Description</th>
                                    <th>Part Number</th>
                                </tr>
                            </thead>
                            <tbody>

                                <tr>
                                    <td>1</td>
                                    <td>KM-8100</td>
                                    <td>KM-8100</td>
                                    <td>Genius Smart KM-8100 Keyboard + Mouse Wireless</td>
                                    <td>Genius Smart KM-8100 Keyboard + Mouse Wireless</td>
                                    <td>KM-8100</td>
                                </tr>
                                <tr>
                                    <td>2</td>
                                    <td>MS2431-1050</td>
                                    <td></td>
                                    <td>Honeywell 2431 USB</td>
                                    <td>Honeywell Scanner-only: 508 mm (20.07) Diamonex platter
                                        (46-01087).RS232 USB.IBM 460x
                                    </td>
                                    <td>MS2431-105D</td>
                                </tr>
                                <tr>
                                    <td>3</td>
                                    <td>CS-6035</td>
                                    <td>CS-6035</td>
                                    <td>CITYPOS CASHDRAWER 6 Bill 4 Coin Slot.</td>
                                    <td>CITYPOS CASHDRAWER 6 Bill 4 Coin Slot.</td>
                                    <td>CS-6035</td>
                                </tr>
                                <tr>
                                    <td>4</td>
                                    <td>NX-7005</td>
                                    <td>NX-7005</td>
                                    <td>Genius NX-700 Wireless Mouse</td>
                                    <td>Genius NX-700 Wireless Mouse</td>
                                    <td>NX-7005</td>
                                </tr>
                                <tr>
                                    <td>5</td>
                                    <td>DX-110</td>
                                    <td>DX-110</td>
                                    <td>Genius DX-110 Wireless Mouse</td>
                                    <td>Genius DX-110 Wireless Mouse</td>
                                    <td>DX-110</td>
                                </tr>
                                <tr>
                                    <td>6</td>
                                    <td>KB-110x</td>
                                    <td>KB-110x</td>
                                    <td>Genius KB-110x Wireless Mouse</td>
                                    <td>Genius KB-110x Wireless Mouse</td>
                                    <td>KB-110x</td>
                                </tr>


                            </tbody>
                        </table>


                    </div>
                </div>
            </div>

        </div>

    </div>
@endsection
