@extends('admin.layouts.app')
@section('content')
    <div>
        <ul class="flex space-x-2 rtl:space-x-reverse">
            <li>
                <a href="{{ route('admin.dashboard') }}" class="text-primary hover:underline">Dashboard</a>
            </li>
            <li class="before:content-['/'] ltr:before:mr-1 rtl:before:ml-1">
                <span>Purchase Order</span>
            </li>
        </ul>
    </div>
    <div class="pt-5">
        <!-- Purchase Header Section -->
        <div class="panel mb-4 border-t border-primary ">
            <div class="mb-5 flex items-center justify-between">
                <h5 class="text-lg font-semibold dark:text-white-light">Purchase Header</h5>
            </div>
            <form class="space-y-5">
                <div class="grid grid-cols-1 gap-4 sm:grid-cols-2">
                    <div>
                        <label for="purchId">Purch ID</label>
                        <input id="purchId" type="text" placeholder="Purchase ID" class="form-input">
                    </div>
                    <div>
                        <label for="name">Name</label>
                        <input id="name" type="text" placeholder="Purchase Name" class="form-input">
                    </div>
                    <div>
                        <label for="reference">Reference</label>
                        <input id="reference" type="text" placeholder="Reference" class="form-input">
                    </div>
                    <div>
                        <label for="date">Date</label>
                        <input id="date" type="date" class="form-input">
                    </div>
                    <div class="col-span-2">
                        <label for="notes">Notes</label>
                        <textarea id="notes" placeholder="Enter ..." class="form-input"></textarea>
                    </div>
                </div>
            </form>
        </div>

        <!-- Vendor Section -->
        <div class="panel mb-4 border-t border-primary">
            <div class="mb-5 flex items-center justify-between">
                <h5 class="text-lg font-semibold dark:text-white-light">Vendor</h5>
            </div>
            <form class="space-y-5">
                <div class="grid grid-cols-1 gap-4 sm:grid-cols-3">
                    <div>
                        <label for="vendor">Vendor</label>
                        <select id="vendor" class="form-select">
                            <option>Select Vendor</option>
                            <!-- Additional options can be added here -->
                        </select>
                    </div>
                    <div>
                        <label for="currency">Currency</label>
                        <select id="currency" class="form-select">
                            <option>Saudi Arabian Riyal</option>
                            <!-- Additional currency options can be added here -->
                        </select>
                    </div>
                    <div>
                        <label for="paymentTerms">Payment Terms</label>
                        <select id="paymentTerms" class="form-select">
                            <option>Net 30</option>
                            <!-- Additional terms can be added here -->
                        </select>
                    </div>
                    <div class="col-span-2">
                        <label for="deliveryTerms">Delivery Terms</label>
                        <input id="deliveryTerms" type="text" placeholder="Terms Of Delivery" class="form-input">
                    </div>
                </div>
            </form>
        </div>

        <!-- Creation Details Section -->
        <div class="panel mb-4 border-t border-primary">
            <div class="mb-5 flex items-center justify-between">
                <h5 class="text-lg font-semibold dark:text-white-light">Creation Details</h5>
            </div>
            <form class="space-y-5">
                <div class="grid grid-cols-1 gap-4 sm:grid-cols-3">
                    <div>
                        <label for="createdDate">Created Date</label>
                        <input id="createdDate" type="text" placeholder="Created Datetime" class="form-input" disabled>
                    </div>
                    <div>
                        <label for="createdBy">Created By</label>
                        <input id="createdBy" type="text" placeholder="Created By" class="form-input" disabled>
                    </div>
                    <div>
                        <label for="modifiedDate">Modified Date</label>
                        <input id="modifiedDate" type="text" placeholder="Modified Datetime" class="form-input" disabled>
                    </div>
                    <div>
                        <label for="modifiedBy">Modified By</label>
                        <input id="modifiedBy" type="text" placeholder="Modified By" class="form-input" disabled>
                    </div>
                </div>
                <div class="flex justify-end">
                    <button type="submit" class="btn btn-primary">Submit</button>
                </div>
            </form>
        </div>
        <!-- Purchase Line Section -->
        <div class="panel mb-4 border-t border-primary">
            <div class="mb-5 flex items-center justify-between">
                <h5 class="text-lg font-semibold dark:text-white-light">Purchase Line</h5>
            </div>
            
        </div>
        <div class="panel mb-4 border-t border-primary">
            <div class="mb-5 flex items-center justify-between">
                <h5 class="text-lg font-semibold dark:text-white-light">Attachments</h5>
            </div>
            
        </div>
    </div>
@endsection
