@extends('admin.layouts.app')
@section('content')
    <div>
        <ul class="flex space-x-2 rtl:space-x-reverse">
            <li>
                <a href="{{ route('admin.dashboard') }}" class="text-primary hover:underline">Dashboard</a>
            </li>
            <li class="before:content-['/'] ltr:before:mr-1 rtl:before:ml-1">
                <span>Packing Slip</span>
            </li>
        </ul>
    </div>
    <div class="pt-5">
        <!-- Packing Slip Header Section -->
        <div class="panel mb-4">
            <div class="mb-5 flex items-center justify-between">
                <h5 class="text-lg font-semibold dark:text-white-light">Packing Slip Header</h5>
            </div>
            <form class="space-y-5">
                <div class="grid grid-cols-1 gap-4 sm:grid-cols-3">
                    <div>
                        <label for="packingSlipId">PackingSlip ID</label>
                        <input id="packingSlipId" type="text" placeholder="PackingSlip ID" class="form-input" disabled>
                    </div>
                    <div>
                        <label for="purchId">Purch ID</label>
                        <input id="purchId" type="text" placeholder="Purch ID" class="form-input">
                    </div>
                    <div>
                        <label for="warehouse">Warehouse</label>
                        <select id="warehouse" class="form-select">
                            <option>Select Warehouse</option>
                            <!-- Additional options can be added here -->
                        </select>
                    </div>
                    <div>
                        <label for="name">Name</label>
                        <input id="name" type="text" placeholder="Name" class="form-input">
                    </div>
                    <div>
                        <label for="reference">Reference</label>
                        <input id="reference" type="text" placeholder="Reference" class="form-input">
                    </div>
                    <div>
                        <label for="date">Date</label>
                        <input id="date" type="date" class="form-input">
                    </div>
                    <div>
                        <label for="notes">Notes</label>
                        <textarea id="notes" placeholder="Enter ..." class="form-input"></textarea>
                    </div>
                </div>
            </form>
        </div>

        <!-- Vendor Section -->
        <div class="panel mb-4">
            <div class="mb-5 flex items-center justify-between">
                <h5 class="text-lg font-semibold dark:text-white-light">Vendor</h5>
            </div>
            <form class="space-y-5">
                <div class="grid grid-cols-1 gap-4 sm:grid-cols-3">
                    <div>
                        <label for="vendorId">Vendor ID</label>
                        <select id="vendorId" class="form-select">
                            <option>Select Vendor ID</option>
                            <!-- Additional options can be added here -->
                        </select>
                    </div>
                </div>
            </form>
        </div>

        <!-- Creation Details Section -->
        <div class="panel mb-4">
            <div class="mb-5 flex items-center justify-between">
                <h5 class="text-lg font-semibold dark:text-white-light">Creation Details</h5>
            </div>
            <form class="space-y-5">
                <div class="grid grid-cols-1 gap-4 sm:grid-cols-3">
                    <div>
                        <label for="createdDt">CreatedDT</label>
                        <input id="createdDt" type="text" placeholder="Created Datetime" class="form-input" disabled>
                    </div>
                    <div>
                        <label for="createdBy">Created By</label>
                        <input id="createdBy" type="text" placeholder="Created By" class="form-input" disabled>
                    </div>
                    <div>
                        <label for="modifiedDt">ModifiedDT</label>
                        <input id="modifiedDt" type="text" placeholder="Modified Datetime" class="form-input" disabled>
                    </div>
                    <div>
                        <label for="modifiedBy">Modified By</label>
                        <input id="modifiedBy" type="text" placeholder="Modified By" class="form-input" disabled>
                    </div>
                </div>
                <div class="flex justify-end">
                    <button type="submit" class="btn btn-primary">Submit</button>
                </div>
            </form>
        </div>

        <!-- Packing Line Section -->
        <div class="panel mb-4">
            <div class="mb-5 flex items-center justify-between">
                <h5 class="text-lg font-semibold dark:text-white-light">Packing Line</h5>
            </div>
            <form class="space-y-5">
                <!-- Add Packing Line fields here if needed -->
                <div class="flex justify-end">
                    <button type="button" class="btn btn-primary">Register Packing Slip</button>
                </div>
            </form>
        </div>
    </div>
@endsection
