@extends('admin.layouts.app')
@section('content')
    <div>
        <ul class="flex space-x-2 rtl:space-x-reverse">
            <li>
                <a href="{{ route('admin.dashboard') }}" class="text-primary hover:underline">Dashboard</a>
            </li>
            <li class="before:content-['/'] ltr:before:mr-1 rtl:before:ml-1">
                <span>Production Request</span>
            </li>
        </ul>
    </div>
    <div class="pt-5">
        <!-- Production Header Section -->
        <div class="panel mb-4 border-t border-primary">
            <div class="mb-5 flex items-center justify-between">
                <h5 class="text-lg font-semibold dark:text-white-light">Production Header</h5>
            </div>
            <form class="space-y-5">
                <div class="grid grid-cols-1 gap-4 sm:grid-cols-2">
                    <div>
                        <label for="prodId">ProdID</label>
                        <input id="prodId" type="text" placeholder="Production Request ID" class="form-input">
                    </div>
                    <div>
                        <label for="name">Name</label>
                        <input id="name" type="text" placeholder="Production Name" class="form-input">
                    </div>
                    <div>
                        <label for="reference">Reference</label>
                        <input id="reference" type="text" placeholder="Reference" class="form-input">
                    </div>
                    <div>
                        <label for="date">Date</label>
                        <input id="date" type="date" class="form-input">
                    </div>
                    <div>
                        <label for="item">Item</label>
                        <select id="item" class="form-select">
                            <option>Select Item</option>
                            <!-- Add additional item options here -->
                        </select>
                    </div>
                    <div>
                        <label for="quantity">Quantity</label>
                        <input id="quantity" type="number" placeholder="Requested Quantity" class="form-input">
                    </div>
                    <div class="col-span-2">
                        <label for="notes">Notes</label>
                        <textarea id="notes" placeholder="Enter ..." class="form-input"></textarea>
                    </div>
                </div>
                <div class="flex justify-end">
                    <button type="submit" class="btn btn-primary">Submit</button>
                </div>
            </form>
        </div>

        <!-- Creation Details Section -->
        <div class="panel mb-4 border-t border-primary">
            <div class="mb-5 flex items-center justify-between">
                <h5 class="text-lg font-semibold dark:text-white-light">Creation Details</h5>
            </div>
            <form class="space-y-5">
                <div class="grid grid-cols-1 gap-4 sm:grid-cols-3">
                    <div>
                        <label for="createdDate">Created Date</label>
                        <input id="createdDate" type="text" placeholder="Created Datetime" class="form-input" disabled>
                    </div>
                    <div>
                        <label for="createdBy">Created By</label>
                        <input id="createdBy" type="text" placeholder="Created By" class="form-input" disabled>
                    </div>
                    <div>
                        <label for="modifiedDate">Modified Date</label>
                        <input id="modifiedDate" type="text" placeholder="Modified Datetime" class="form-input" disabled>
                    </div>
                    <div>
                        <label for="modifiedBy">Modified By</label>
                        <input id="modifiedBy" type="text" placeholder="Modified By" class="form-input" disabled>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection
