@extends('admin.layouts.app')
@section('content')
    <div>
        <ul class="flex space-x-2 rtl:space-x-reverse">
            <li>
                <a href="{{ route('admin.dashboard') }}" class="text-primary hover:underline">Dashboard</a>
            </li>
            <li class="before:content-['/'] ltr:before:mr-1 rtl:before:ml-1">
                <span>Purchase Receive</span>
            </li>
        </ul>
    </div>
    <div class="pt-5">
        <!-- Purchase Receive Header Section -->
        <div class="panel mb-4 border-t border-primary ">
            <div class="mb-5 flex items-center justify-between">
                <h5 class="text-lg font-semibold dark:text-white-light">Purchase Receive Header</h5>
            </div>
            <form class="space-y-5">
                <div class="grid grid-cols-1 gap-4 sm:grid-cols-2">
                    <div>
                        <label for="receiveId">Receive ID</label>
                        <input id="receiveId" type="text" placeholder="Receive ID" class="form-input">
                    </div>
                    <div>
                        <label for="packingSlipId">PackingSlip ID</label>
                        <select id="packingSlipId" class="form-select">
                            <option>Select Packing Slip</option>
                            <!-- Packing Slip options can be added here -->
                        </select>
                    </div>
                    <div>
                        <label for="warehouse">Warehouse</label>
                        <select id="warehouse" class="form-select">
                            <option>Select Warehouse</option>
                            <option value="1">Blue Star Int'l</option>
                            <option value="2">Logicom Saudi Arabia</option>
                            <option value="3">Test Packing Slip</option>
                            <option value="4">New Packing Slip M</option>
                            <option value="5">New Packing M</option>
                            <!-- Add more options here if needed -->
                        </select>
                    </div>
                    
                    <div class="col-span-2">
                        <label for="name">Name</label>
                        <input id="name" type="text" placeholder="Receive Name" class="form-input">
                    </div>
                    <div class="col-span-2">
                        <label for="reference">Reference</label>
                        <input id="reference" type="text" placeholder="Reference" class="form-input">
                    </div>
                    <div>
                        <label for="date">Date</label>
                        <input id="date" type="date" class="form-input">
                    </div>
                   
                    <div class="col-span-2">
                        <label for="notes">Notes</label>
                        <textarea id="notes" placeholder="Enter ..." class="form-input"></textarea>
                    </div>
                </div>
            </form>
        </div>

        <!-- Vendor Section -->
        <div class="panel mb-4 border-t border-primary">
            <div class="mb-5 flex items-center justify-between">
                <h5 class="text-lg font-semibold dark:text-white-light">Vendor</h5>
            </div>
            <form class="space-y-5">
                <div class="grid grid-cols-1 gap-4 sm:grid-cols-3">
                    <div>
                        <label for="vendorId">Vendor ID</label>
                        <select id="vendorId" class="form-select">
                            <option>Select Vendor ID</option>
                            <!-- Additional vendor options can be added here -->
                        </select>
                    </div>
                </div>
            </form>
        </div>

        <!-- Creation Details Section -->
        <div class="panel mb-4 border-t border-primary">
            <div class="mb-5 flex items-center justify-between">
                <h5 class="text-lg font-semibold dark:text-white-light">Creation Details</h5>
            </div>
            <form class="space-y-5">
                <div class="grid grid-cols-1 gap-4 sm:grid-cols-3">
                    <div>
                        <label for="createdDate">Created Date</label>
                        <input id="createdDate" type="text" placeholder="Created Datetime" class="form-input" disabled>
                    </div>
                    <div>
                        <label for="createdBy">Created By</label>
                        <input id="createdBy" type="text" placeholder="Created By" class="form-input" disabled>
                    </div>
                    <div>
                        <label for="modifiedDate">Modified Date</label>
                        <input id="modifiedDate" type="text" placeholder="Modified Datetime" class="form-input" disabled>
                    </div>
                    <div>
                        <label for="modifiedBy">Modified By</label>
                        <input id="modifiedBy" type="text" placeholder="Modified By" class="form-input" disabled>
                    </div>
                </div>
                <div class="flex justify-end">
                    <a class="btn btn-primary" href="{{ route('admin.InvoicePurchaseReceive') }}">Submit</a>
                </div>
            </form>
        </div>

        <!-- Purchase Line Section -->
        <div class="panel mb-4 border-t border-primary">
            <div class="mb-5 flex items-center justify-between">
                <h5 class="text-lg font-semibold dark:text-white-light">Purchase Receive Line</h5>
            </div>
            <!-- Additional fields for Purchase Line can be added here if needed -->
        </div>

    </div>
@endsection
