@extends('admin.layouts.app')
@section('content')
    <div>
        <ul class="flex space-x-2 rtl:space-x-reverse">
            <li>
                <a href="{{ route('admin.dashboard') }}" class="text-primary hover:underline">Dashboard</a>
            </li>
            <li class="before:content-['/'] ltr:before:mr-1 rtl:before:ml-1">
                <span>Transfer Issue Quantity Difference</span>
            </li>
        </ul>


        <div class="pt-5">



            <div class="panel">
                  <!-- Transfer Header Section -->
                  <div class="mb-5 flex items-center justify-between">
                    <h5 class="text-lg font-semibold dark:text-white-light">TIQD List</h5>
                </div>


                <div class="mb-5">
                    <div class="table-responsive">
                        <table>
                            <thead>
                                <tr>
                                    <th>ISSUEID</th>
                                    <th>Transfer ID</th>
                                    <th>Item ID</th>
                                    <th>Item Name</th>
                                    <th>Transfer Quantity</th>
                                    <th>Transfer Issued</th>
                                    <th>Quantity Diff</th>
                                    <th>Created Date</th>
                                    <th>Created By</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>1</td>
                                    <td>7</td>
                                    <td>57</td>
                                    <td>Aruba Instant On AP12 (EG) 3x3 11ac Wave2 Indoor Access Point</td>
                                    <td>20.00</td>
                                    <td>20.00</td>
                                    <td>0.00</td>
                                    <td>11/23/2023</td>
                                    <td>admin21</td>
                                </tr>
                                <tr>
                                    <td>1</td>
                                    <td>7</td>
                                    <td>1</td>
                                    <td>Genius Smart KM-8100 Keyboard + Mouse Wireless</td>
                                    <td>12.00</td>
                                    <td>12.00</td>
                                    <td>0.00</td>
                                    <td>11/23/2023</td>
                                    <td>admin21</td>
                                </tr>
                                <tr>
                                    <td>1</td>
                                    <td>7</td>
                                    <td>106</td>
                                    <td>EPSON TM-T88V (082): SERIAL, PS, EDG, UK</td>
                                    <td>30.00</td>
                                    <td>30.00</td>
                                    <td>0.00</td>
                                    <td>11/23/2023</td>
                                    <td>admin21</td>
                                </tr>
                            </tbody>
                        </table>

                    </div>
                </div>
            </div>

        </div>

    </div>
@endsection
