@extends('admin.layouts.app')
@section('content')
    <div x-data="finance">
        <ul class="flex space-x-2 rtl:space-x-reverse">
            <li>
                <a href="javascript:;" class="text-primary hover:underline">Dashboard</a>
            </li>
            <li class="before:content-['/'] ltr:before:mr-1 rtl:before:ml-1">
                <span>Control</span>
            </li>
        </ul>
        <div class="pt-5">


            <div class="grid grid-cols-1 gap-6 xl:grid-cols-1">
                <!-- Favorites -->
                <div>
                    <div class="grid grid-cols-1 gap-6 sm:grid-cols-4 md:mb-5">
                        <!-- Panel 1: Item Count -->
                        <div class="panel">
                            <div class="mb-5 flex items-center font-semibold">
                                <div class="ltr:ml-2 rtl:mr-2">
                                    <h6 class="text-gray-600 dark:text-white-light">ITEM COUNT</h6>
                                </div>
                            </div>
                            <div class="ltr:ml-2 rtl:mr-2 font-semibold">
                                <h2
                                    class="mb-1 bg-white-light/30 py-3 px-7 font-bold uppercase dark:bg-dark dark:bg-opacity-[0.08]">
                                    <span>655</span>
                                </h2>
                            </div>
                            <div class="flex items-center justify-between py-2 font-bold">
                                <a href=""><span class="text-sm font-normal text-success">More Info</span></a>
                            </div>
                        </div>

                        <!-- Panel 2: Inventory Value -->
                        <div class="panel">
                            <div class="mb-5 flex items-center font-semibold">
                                <div class="ltr:ml-2 rtl:mr-2">
                                    <h6 class="text-gray-600 dark:text-white-light">INVENTORY VALUE</h6>
                                </div>
                            </div>
                            <div class="ltr:ml-2 rtl:mr-2 font-semibold">
                                <h2
                                    class="mb-1 bg-white-light/30 py-3 px-7 font-bold uppercase dark:bg-dark dark:bg-opacity-[0.08]">
                                    <span>3,143,290.91 SAR</span>
                                </h2>
                            </div>
                        </div>

                        <!-- Panel 3: Asset Count -->
                        <div class="panel">
                            <div class="mb-5 flex items-center font-semibold">
                                <div class="ltr:ml-2 rtl:mr-2">
                                    <h6 class="text-gray-600 dark:text-white-light">ASSET COUNT</h6>
                                </div>
                            </div>
                            <div class="ltr:ml-2 rtl:mr-2 font-semibold">
                                <h2
                                    class="mb-1 bg-white-light/30 py-3 px-7 font-bold uppercase dark:bg-dark dark:bg-opacity-[0.08]">
                                    <span>73</span>
                                </h2>
                            </div>
                            <div class="flex items-center justify-between py-2 font-bold">
                                <a href=""><span class="text-sm font-normal text-success">More Info</span></a>
                            </div>
                        </div>

                        <!-- Panel 4: Assets Value -->
                        <div class="panel">
                            <div class="mb-5 flex items-center font-semibold">
                                <div class="ltr:ml-2 rtl:mr-2">
                                    <h6 class="text-gray-600 dark:text-white-light">ASSETS VALUE</h6>
                                </div>
                            </div>
                            <div class="ltr:ml-2 rtl:mr-2 font-semibold">
                                <h2
                                    class="mb-1 bg-white-light/30 py-3 px-7 font-bold uppercase dark:bg-dark dark:bg-opacity-[0.08]">
                                    <span>795,735.00 SAR</span>
                                </h2>
                            </div>
                        </div>

                        <!-- Panel 5: Open Sales Orders -->
                        <div class="panel">
                            <div class="mb-5 flex items-center font-semibold">
                                <div class="ltr:ml-2 rtl:mr-2">
                                    <h6 class="text-gray-600 dark:text-white-light">OPEN SALES ORDERS</h6>
                                </div>
                            </div>
                            <div class="ltr:ml-2 rtl:mr-2 font-semibold">
                                <h2
                                    class="mb-1 bg-white-light/30 py-3 px-7 font-bold uppercase dark:bg-dark dark:bg-opacity-[0.08]">
                                    <span>0</span>
                                </h2>
                            </div>
                        </div>

                        <!-- Panel 6: Closed Sales Orders -->
                        <div class="panel">
                            <div class="mb-5 flex items-center font-semibold">
                                <div class="ltr:ml-2 rtl:mr-2">
                                    <h6 class="text-gray-600 dark:text-white-light">CLOSED SALES ORDERS</h6>
                                </div>
                            </div>
                            <div class="ltr:ml-2 rtl:mr-2 font-semibold">
                                <h2
                                    class="mb-1 bg-white-light/30 py-3 px-7 font-bold uppercase dark:bg-dark dark:bg-opacity-[0.08]">
                                    <span>259</span>
                                </h2>
                            </div>
                        </div>

                        <!-- Panel 7: Sales Today -->
                        <div class="panel">
                            <div class="mb-5 flex items-center font-semibold">
                                <div class="ltr:ml-2 rtl:mr-2">
                                    <h6 class="text-gray-600 dark:text-white-light">SALES TODAY</h6>
                                </div>
                            </div>
                            <div class="ltr:ml-2 rtl:mr-2 font-semibold">
                                <h2
                                    class="mb-1 bg-white-light/30 py-3 px-7 font-bold uppercase dark:bg-dark dark:bg-opacity-[0.08]">
                                    <span>0 SAR</span>
                                </h2>
                            </div>
                        </div>

                        <!-- Panel 8: Sales MTD -->
                        <div class="panel">
                            <div class="mb-5 flex items-center font-semibold">
                                <div class="ltr:ml-2 rtl:mr-2">
                                    <h6 class="text-gray-600 dark:text-white-light">SALES MTD</h6>
                                </div>
                            </div>
                            <div class="ltr:ml-2 rtl:mr-2 font-semibold">
                                <h2
                                    class="mb-1 bg-white-light/30 py-3 px-7 font-bold uppercase dark:bg-dark dark:bg-opacity-[0.08]">
                                    <span>4,000 SAR</span>
                                </h2>
                            </div>
                        </div>

                        <!-- Panel 9: Open Purchase Orders -->
                        <div class="panel">
                            <div class="mb-5 flex items-center font-semibold">
                                <div class="ltr:ml-2 rtl:mr-2">
                                    <h6 class="text-gray-600 dark:text-white-light">OPEN PURCHASE ORDERS</h6>
                                </div>
                            </div>
                            <div class="ltr:ml-2 rtl:mr-2 font-semibold">
                                <h2
                                    class="mb-1 bg-white-light/30 py-3 px-7 font-bold uppercase dark:bg-dark dark:bg-opacity-[0.08]">
                                    <span>101</span>
                                </h2>
                            </div>
                        </div>

                        <!-- Panel 10: Closed Purchase Orders -->
                        <div class="panel">
                            <div class="mb-5 flex items-center font-semibold">
                                <div class="ltr:ml-2 rtl:mr-2">
                                    <h6 class="text-gray-600 dark:text-white-light">CLOSED PURCHASE ORDERS</h6>
                                </div>
                            </div>
                            <div class="ltr:ml-2 rtl:mr-2 font-semibold">
                                <h2
                                    class="mb-1 bg-white-light/30 py-3 px-7 font-bold uppercase dark:bg-dark dark:bg-opacity-[0.08]">
                                    <span>68</span>
                                </h2>
                            </div>
                        </div>

                        <!-- Panel 11: Purchase Today -->
                        <div class="panel">
                            <div class="mb-5 flex items-center font-semibold">
                                <div class="ltr:ml-2 rtl:mr-2">
                                    <h6 class="text-gray-600 dark:text-white-light">PURCHASE TODAY</h6>
                                </div>
                            </div>
                            <div class="ltr:ml-2 rtl:mr-2 font-semibold">
                                <h2
                                    class="mb-1 bg-white-light/30 py-3 px-7 font-bold uppercase dark:bg-dark dark:bg-opacity-[0.08]">
                                    <span>0 SAR</span>
                                </h2>
                            </div>
                        </div>

                        <!-- Panel 12: Purchase MTD -->
                        <div class="panel">
                            <div class="mb-5 flex items-center font-semibold">
                                <div class="ltr:ml-2 rtl:mr-2">
                                    <h6 class="text-gray-600 dark:text-white-light">PURCHASE MTD</h6>
                                </div>
                            </div>
                            <div class="ltr:ml-2 rtl:mr-2 font-semibold">
                                <h2
                                    class="mb-1 bg-white-light/30 py-3 px-7 font-bold uppercase dark:bg-dark dark:bg-opacity-[0.08]">
                                    <span>4,920 SAR</span>
                                </h2>
                            </div>
                        </div>

                        <!-- Panel 13: Open Sales Quotations -->
                        <div class="panel">
                            <div class="mb-5 flex items-center font-semibold">
                                <div class="ltr:ml-2 rtl:mr-2">
                                    <h6 class="text-gray-600 dark:text-white-light">OPEN SALES QUOTATIONS</h6>
                                </div>
                            </div>
                            <div class="ltr:ml-2 rtl:mr-2 font-semibold">
                                <h2
                                    class="mb-1 bg-white-light/30 py-3 px-7 font-bold uppercase dark:bg-dark dark:bg-opacity-[0.08]">
                                    <span>0</span>
                                </h2>
                            </div>
                        </div>

                        <!-- Panel 14: Closed Sales Quotations -->
                        <div class="panel">
                            <div class="mb-5 flex items-center font-semibold">
                                <div class="ltr:ml-2 rtl:mr-2">
                                    <h6 class="text-gray-600 dark:text-white-light">CLOSED SALES QUOTATIONS</h6>
                                </div>
                            </div>
                            <div class="ltr:ml-2 rtl:mr-2 font-semibold">
                                <h2
                                    class="mb-1 bg-white-light/30 py-3 px-7 font-bold uppercase dark:bg-dark dark:bg-opacity-[0.08]">
                                    <span>36</span>
                                </h2>
                            </div>
                        </div>
                    </div>

                </div>


            </div>

            
        </div>
    </div>
@endsection
