@extends('admin.layouts.app')
@section('content')
    <div>
        <ul class="flex space-x-2 rtl:space-x-reverse">
            <li>
                <a href="{{ route('admin.dashboard') }}" class="text-primary hover:underline">Dashboard</a>
            </li>
            <li class="before:content-['/'] ltr:before:mr-1 rtl:before:ml-1">
                <span>Update Basic Details</span>
            </li>
        </ul>
    </div>
    <div class="pt-5">
        <!-- Update Item Section -->
        <div class="panel mb-4 border-t border-primary">
            <div class="mb-5 flex items-center justify-between">
                <h5 class="text-lg font-semibold dark:text-white-light">Basic Details</h5>
            </div>
            <form class="space-y-5">
                <div class="grid grid-cols-1 gap-4 sm:grid-cols-3">
                    <div>
                        <label for="itemId">Item ID</label>
                        <div class="flex">
                        
                            <input id="itemId" type="text" placeholder="Item ID" class="form-input">
                            <button type="button" class="btn btn-outline-secondary ltr:rounded-l-none rtl:rounded-r-none">
                                Load
                            </button>
                        </div>
                    </div>
                    
                    <div>
                        <label for="itemRef">Item Ref</label>
                        <input id="itemRef" type="text" placeholder="Item Ref" class="form-input">
                    </div>
                    <div>
                        <label for="itemName">Name</label>
                        <input id="itemName" type="text" placeholder="Item Name" class="form-input">
                    </div>
                    <div>
                        <label for="itemNameE">Name (E)</label>
                        <input id="itemNameE" type="text" placeholder="Name (English)" class="form-input">
                    </div>
                    <div>
                        <label for="itemNameA">Name (A)</label>
                        <input id="itemNameA" type="text" placeholder="Name (Arabic)" class="form-input">
                    </div>
                    <div>
                        <label for="description">Description</label>
                        <input id="description" type="text" placeholder="Description" class="form-input">
                    </div>
                    <div>
                        <label for="shortDesc">Short </label>
                        <input id="shortDesc" type="text" placeholder="Short " class="form-input">
                    </div>
                    <div>
                        <label for="partNumber">Part Number</label>
                        <input id="partNumber" type="text" placeholder="Part Number" class="form-input">
                    </div>
                    <div>
                        <label for="itemGroup">Item Group</label>
                        <select id="itemGroup" class="form-select">
                            <option>Barcode Accessory</option>
                            <!-- Additional options can be added here -->
                        </select>
                    </div>
                </div>
                <div class="mb-5 flex items-center gap-2">
                    <button type="button" class="btn btn-primary">Print BRCODE</button>
                </div>
            </form>
        </div>

        <!-- Additional Sections (Item Value, Inventory Details) -->
        <!-- Item Value Section -->
        <div class="panel mb-4 border-t border-primary">

            <form class="space-y-5">
                <div class="grid grid-cols-1 gap-4 sm:grid-cols-3">
                    <div>
                        <label for="category">Category</label>
                        <select id="category" class="form-select">
                            <option>Access Controller</option>
                            <!-- Additional options can be added here -->
                        </select>
                    </div>
                    <div>
                        <label for="vendor">Vendor</label>
                        <select id="vendor" class="form-select">
                            <option>Acer</option>
                            <!-- Additional options can be added here -->
                        </select>
                    </div>
                    <div>
                        <label for="tag">Tag</label>
                        <input id="tag" type="text" placeholder="Tag" class="form-input">
                    </div>
                    <div class="col-span-3">
                        <label for="notes">Notes</label>
                        <textarea id="notes" placeholder="Enter notes here..." class="form-input"></textarea>
                    </div>
                </div>
                <div class="mb-5 flex items-center gap-2">
                    <button type="button" class="btn btn-primary">Part Number</button>
                    <h5 class="text-sm font-semibold dark:text-white-light"> Part Number:</h5>
                </div>
            </form>
        </div>


    </div>
@endsection
