  <!-- start sidebar section -->
  <div :class="{ 'dark text-white-dark': $store.app.semidark }">
      <nav x-data="sidebar"
          class="sidebar fixed top-0 bottom-0 z-50 h-full min-h-screen w-[260px] shadow-[5px_0_25px_0_rgba(94,92,154,0.1)] transition-all duration-300">
          <div class="h-full bg-white dark:bg-[#0e1726]">
              <div class="flex items-center justify-between px-4 py-3">
                  <a href="{{ route('admin.dashboard') }}" class="main-logo flex shrink-0 items-center">
                      <img class="ml-[5px] w-8 flex-none" src="{{ asset('admin-assets/assets/images/logo.png') }}"
                          alt="image">
                      <span
                          class="align-middle text-2xl font-bold ltr:ml-1.5 rtl:mr-1.5 dark:text-white-light lg:inline">{{ Auth::guard('admin')->user()->name }}</span>
                  </a>
                  <a href="javascript:;"
                      class="collapse-icon flex h-8 w-8 items-center rounded-full transition duration-300 hover:bg-gray-500/10 rtl:rotate-180 dark:text-white-light dark:hover:bg-dark-light/10"
                      @click="$store.app.toggleSidebar()">
                      <svg class="m-auto h-5 w-5" width="20" height="20" viewbox="0 0 24 24" fill="none"
                          xmlns="http://www.w3.org/2000/svg">
                          <path d="M13 19L7 12L13 5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"
                              stroke-linejoin="round"></path>
                          <path opacity="0.5" d="M16.9998 19L10.9998 12L16.9998 5" stroke="currentColor"
                              stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                      </svg>
                  </a>
              </div>
              <ul class="perfect-scrollbar relative h-[calc(100vh-80px)] space-y-0.5 overflow-y-auto overflow-x-hidden p-4 py-0 font-semibold"
                  x-data="{ activeDropdown: 'dashboard' }">


                  <h2
                      class="-mx-4 mb-1 flex items-center bg-white-light/30 py-3 px-7 font-extrabold uppercase dark:bg-dark dark:bg-opacity-[0.08]">
                      <svg class="hidden h-5 w-4 flex-none" viewbox="0 0 24 24" stroke="currentColor" stroke-width="1.5"
                          fill="none" stroke-linecap="round" stroke-linejoin="round">
                          <line x1="5" y1="12" x2="19" y2="12"></line>
                      </svg>
                      <span>Main Navigation</span>
                  </h2>

                  <li class="nav-item">
                      <ul>
                          <li class="nav-item">
                              <a href="{{ route('admin.dashboard') }}"
                                  class="group {{ Request::is('admin/dashboard') ? 'active' : '' }}">
                                  <div class="flex items-center">
                                      <svg class="shrink-0 group-hover:!text-primary" width="20" height="20"
                                          viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                          <path opacity="0.5"
                                              d="M2 12.2039C2 9.91549 2 8.77128 2.5192 7.82274C3.0384 6.87421 3.98695 6.28551 5.88403 5.10813L7.88403 3.86687C9.88939 2.62229 10.8921 2 12 2C13.1079 2 14.1106 2.62229 16.116 3.86687L18.116 5.10812C20.0131 6.28551 20.9616 6.87421 21.4808 7.82274C22 8.77128 22 9.91549 22 12.2039V13.725C22 17.6258 22 19.5763 20.8284 20.7881C19.6569 22 17.7712 22 14 22H10C6.22876 22 4.34315 22 3.17157 20.7881C2 19.5763 2 17.6258 2 13.725V12.2039Z"
                                              fill="currentColor"></path>
                                          <path
                                              d="M9 17.25C8.58579 17.25 8.25 17.5858 8.25 18C8.25 18.4142 8.58579 18.75 9 18.75H15C15.4142 18.75 15.75 18.4142 15.75 18C15.75 17.5858 15.4142 17.25 15 17.25H9Z"
                                              fill="currentColor"></path>
                                      </svg>
                                      <span
                                          class="text-black ltr:pl-3 rtl:pr-3 dark:text-[#506690] dark:group-hover:text-white-dark">Dashboard</span>
                                  </div>
                              </a>
                          </li>
                          <li class="menu nav-item">
                              <button type="button" class="nav-link group"
                                  :class="{ 'active': activeDropdown === 'administration' }"
                                  @click="activeDropdown === 'administration' ? activeDropdown = null : activeDropdown = 'administration'">
                                  <div class="flex items-center">
                                      <svg class="shrink-0 group-hover:!text-primary" width="20" height="20"
                                          viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                          <path opacity="0.5"
                                              d="M2 16C2 13.1716 2 11.7574 2.87868 10.8787C3.75736 10 5.17157 10 8 10H16C18.8284 10 20.2426 10 21.1213 10.8787C22 11.7574 22 13.1716 22 16C22 18.8284 22 20.2426 21.1213 21.1213C20.2426 22 18.8284 22 16 22H8C5.17157 22 3.75736 22 2.87868 21.1213C2 20.2426 2 18.8284 2 16Z"
                                              fill="currentColor"></path>
                                          <path
                                              d="M8 17C8.55228 17 9 16.5523 9 16C9 15.4477 8.55228 15 8 15C7.44772 15 7 15.4477 7 16C7 16.5523 7.44772 17 8 17Z"
                                              fill="currentColor"></path>
                                          <path
                                              d="M12 17C12.5523 17 13 16.5523 13 16C13 15.4477 12.5523 15 12 15C11.4477 15 11 15.4477 11 16C11 16.5523 11.4477 17 12 17Z"
                                              fill="currentColor"></path>
                                          <path
                                              d="M17 16C17 16.5523 16.5523 17 16 17C15.4477 17 15 16.5523 15 16C15 15.4477 15.4477 15 16 15C16.5523 15 17 15.4477 17 16Z"
                                              fill="currentColor"></path>
                                          <path
                                              d="M6.75 8C6.75 5.10051 9.10051 2.75 12 2.75C14.8995 2.75 17.25 5.10051 17.25 8V10.0036C17.8174 10.0089 18.3135 10.022 18.75 10.0546V8C18.75 4.27208 15.7279 1.25 12 1.25C8.27208 1.25 5.25 4.27208 5.25 8V10.0546C5.68651 10.022 6.18264 10.0089 6.75 10.0036V8Z"
                                              fill="currentColor"></path>
                                      </svg>
                                      <span
                                          class="text-black ltr:pl-3 rtl:pr-3 dark:text-[#506690] dark:group-hover:text-white-dark">Administration</span>
                                  </div>
                                  <div class="rtl:rotate-180"
                                      :class="{ '!rotate-90': activeDropdown === 'administration' }">
                                      <svg width="16" height="16" viewbox="0 0 24 24" fill="none"
                                          xmlns="http://www.w3.org/2000/svg">
                                          <path d="M9 5L15 12L9 19" stroke="currentColor" stroke-width="1.5"
                                              stroke-linecap="round" stroke-linejoin="round"></path>
                                      </svg>
                                  </div>
                              </button>
                              <ul x-cloak="" x-show="activeDropdown === 'administration'" x-collapse=""
                                  class="sub-menu text-gray-500">
                                  <li>
                                      <a href="#">List</a>
                                  </li>
                                  <li>
                                      <a href="#">view</a>
                                  </li>
                                  <li>
                                      <a href="#">edit</a>
                                  </li>
                              </ul>
                          </li>
                          <li class="menu nav-item">
                              <button type="button" class="nav-link group"
                                  :class="{ 'active': activeDropdown === 'basicData' }"
                                  @click="activeDropdown === 'basicData' ? activeDropdown = null : activeDropdown = 'basicData'">
                                  <div class="flex items-center">
                                      <svg class="shrink-0 group-hover:!text-primary" width="20" height="20"
                                          viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"
                                          aria-label="Basic Data Icon" role="img">
                                          <title>Basic Data</title>
                                          <path opacity="0.5"
                                              d="M4 4.75C4 4.33579 4.33579 4 4.75 4H19.25C19.6642 4 20 4.33579 20 4.75V19.25C20 19.6642 19.6642 20 19.25 20H4.75C4.33579 20 4 19.6642 4 19.25V4.75Z"
                                              fill="currentColor"></path>
                                          <path
                                              d="M7 8.5C7 8.08579 7.33579 7.75 7.75 7.75H16.25C16.6642 7.75 17 8.08579 17 8.5C17 8.91421 16.6642 9.25 16.25 9.25H7.75C7.33579 9.25 7 8.91421 7 8.5Z"
                                              fill="currentColor"></path>
                                          <path
                                              d="M7.75 12.25C7.33579 12.25 7 12.5858 7 13C7 13.4142 7.33579 13.75 7.75 13.75H16.25C16.6642 13.75 17 13.4142 17 13C17 12.5858 16.6642 12.25 16.25 12.25H7.75Z"
                                              fill="currentColor"></path>
                                          <path
                                              d="M7 16C7 15.5858 7.33579 15.25 7.75 15.25H12.25C12.6642 15.25 13 15.5858 13 16C13 16.4142 12.6642 16.75 12.25 16.75H7.75C7.33579 16.75 7 16.4142 7 16Z"
                                              fill="currentColor"></path>
                                      </svg>
                                      <span
                                          class="text-black ltr:pl-3 rtl:pr-3 dark:text-[#506690] dark:group-hover:text-white-dark">Basic
                                          Data</span>
                                  </div>

                                  <div class="rtl:rotate-180"
                                      :class="{ '!rotate-90': activeDropdown === 'basicData' }">
                                      <svg width="16" height="16" viewbox="0 0 24 24" fill="none"
                                          xmlns="http://www.w3.org/2000/svg">
                                          <path d="M9 5L15 12L9 19" stroke="currentColor" stroke-width="1.5"
                                              stroke-linecap="round" stroke-linejoin="round"></path>
                                      </svg>
                                  </div>
                              </button>
                              <ul x-cloak="" x-show="activeDropdown === 'basicData'" x-collapse=""
                                  class="sub-menu text-gray-500">
                                  <li>
                                      <a href="#">Currencies</a>
                                  </li>
                                  <li>
                                      <a href="#">Departments</a>
                                  </li>
                                  <li>

                                      <a class="{{ Request::is('admin/locations') ? 'active' : '' }}"
                                          href="{{ route('admin.LocationManage') }}">Locations</a>
                                  </li>
                                  <li>
                                      <a href="#">Sizes</a>
                                  </li>
                                  <li>
                                      <a href="#">Unit of Measure</a>
                                  </li>
                                  <li>
                                      <a href="#">Payment Terms </a>
                                  </li>
                              </ul>
                          </li>
                          <li class="menu nav-item">
                              <button type="button" class="nav-link group"
                                  :class="{ 'active': activeDropdown === 'productManagment' }"
                                  @click="activeDropdown === 'productManagment' ? activeDropdown = null : activeDropdown = 'productManagment'">
                                  <div class="flex items-center">
                                      <svg class="shrink-0 group-hover:!text-primary" width="20" height="20"
                                          viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"
                                          aria-label="Product Management Icon" role="img">
                                          <title>Product Management</title>
                                          <path opacity="0.5" fill-rule="evenodd" clip-rule="evenodd"
                                              d="M12 2C12.4142 2 12.75 2.33579 12.75 2.75V4.05542C13.6705 4.22557 14.5428 4.54764 15.3335 5.00674L16.269 4.2939C16.5971 4.04955 17.0663 4.13419 17.3107 4.46232L19.3107 7.46232C19.555 7.79045 19.4704 8.25966 19.1423 8.50401L18.2068 9.21685C18.7358 10.07 19.1372 11.0137 19.3793 12H20.75C21.1642 12 21.5 12.3358 21.5 12.75V16.25C21.5 16.6642 21.1642 17 20.75 17H19.3793C19.1372 17.9863 18.7358 18.93 18.2068 19.7832L19.1423 20.496C19.4704 20.7404 19.555 21.2096 19.3107 21.5377L17.3107 24.5377C17.0663 24.8658 16.5971 24.9504 16.269 24.706L15.3335 23.9933C14.5428 24.4524 13.6705 24.7744 12.75 24.9446V26.25C12.75 26.6642 12.4142 27 12 27C11.5858 27 11.25 26.6642 11.25 26.25V24.9446C10.3295 24.7744 9.45722 24.4524 8.66652 23.9933L7.73102 24.706C7.40288 24.9504 6.93367 24.8658 6.68932 24.5377L4.68932 21.5377C4.44497 21.2096 4.52961 20.7404 4.85774 20.496L5.7932 19.7832C5.26421 18.93 4.86282 17.9863 4.6207 17H3.25C2.83579 17 2.5 16.6642 2.5 16.25V12.75C2.5 12.3358 2.83579 12 3.25 12H4.6207C4.86282 11.0137 5.26421 10.07 5.7932 9.21685L4.85774 8.50401C4.52961 8.25966 4.44497 7.79045 4.68932 7.46232L6.68932 4.46232C6.93367 4.13419 7.40288 4.04955 7.73102 4.2939L8.66652 5.00674C9.45722 4.54764 10.3295 4.22557 11.25 4.05542V2.75C11.25 2.33579 11.5858 2 12 2ZM12 8C10.067 8 8.5 9.567 8.5 11.5C8.5 13.433 10.067 15 12 15C13.933 15 15.5 13.433 15.5 11.5C15.5 9.567 13.933 8 12 8Z"
                                              fill="currentColor"></path>
                                      </svg>
                                      <span
                                          class="text-black ltr:pl-3 rtl:pr-3 dark:text-[#506690] dark:group-hover:text-white-dark">Product
                                          Management</span>
                                  </div>

                                  <div class="rtl:rotate-180"
                                      :class="{ '!rotate-90': activeDropdown === 'productManagment' }">
                                      <svg width="16" height="16" viewbox="0 0 24 24" fill="none"
                                          xmlns="http://www.w3.org/2000/svg">
                                          <path d="M9 5L15 12L9 19" stroke="currentColor" stroke-width="1.5"
                                              stroke-linecap="round" stroke-linejoin="round"></path>
                                      </svg>
                                  </div>
                              </button>
                              <ul x-cloak="" x-show="activeDropdown === 'productManagment'" x-collapse=""
                                  class="sub-menu text-gray-500">
                                  <li>
                                      <a class="{{ Request::is('admin/item-list') ? 'active' : '' }}"
                                          href="{{ route('admin.ItemList') }}">Item List</a>
                                  </li>
                                  <li>
                                      <a class="{{ Request::is('admin/add-item') ? 'active' : '' }}"
                                          href="{{ route('admin.AddItem') }}">New Item </a>
                                  </li>
                                  <li>
                                      <a class="{{ Request::is('admin/update-item-details') ? 'active' : '' }}"
                                       href="{{ route('admin.itemDetailsUpdate') }}">Update Item</a>
                                  </li>
                                  <li>
                                      <a href="#">Item Values</a>
                                  </li>
                                  <li>
                                      <a href="#">Item Groups</a>
                                  </li>
                                  <li>
                                      <a href="#">Item Category</a>
                                  </li>
                                  <li>
                                      <a href="#">Item Vendors</a>
                                  </li>

                              </ul>
                          </li>
                          <li class="menu nav-item">
                              <button type="button" class="nav-link group"
                                  :class="{ 'active': activeDropdown === 'setup' }"
                                  @click="activeDropdown === 'setup' ? activeDropdown = null : activeDropdown = 'setup'">
                                  <div class="flex items-center">
                                      <svg class="shrink-0 group-hover:!text-primary" width="20" height="20"
                                          viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                          <path opacity="0.5"
                                              d="M13 15.4C13 13.3258 13 12.2887 13.659 11.6444C14.318 11 15.3787 11 17.5 11C19.6213 11 20.682 11 21.341 11.6444C22 12.2887 22 13.3258 22 15.4V17.6C22 19.6742 22 20.7113 21.341 21.3556C20.682 22 19.6213 22 17.5 22C15.3787 22 14.318 22 13.659 21.3556C13 20.7113 13 19.6742 13 17.6V15.4Z"
                                              fill="currentColor"></path>
                                          <path
                                              d="M2 8.6C2 10.6742 2 11.7113 2.65901 12.3556C3.31802 13 4.37868 13 6.5 13C8.62132 13 9.68198 13 10.341 12.3556C11 11.7113 11 10.6742 11 8.6V6.4C11 4.32582 11 3.28873 10.341 2.64437C9.68198 2 8.62132 2 6.5 2C4.37868 2 3.31802 2 2.65901 2.64437C2 3.28873 2 4.32582 2 6.4V8.6Z"
                                              fill="currentColor"></path>
                                          <path
                                              d="M13 5.5C13 4.4128 13 3.8692 13.1713 3.44041C13.3996 2.86867 13.8376 2.41443 14.389 2.17761C14.8024 2 15.3266 2 16.375 2H18.625C19.6734 2 20.1976 2 20.611 2.17761C21.1624 2.41443 21.6004 2.86867 21.8287 3.44041C22 3.8692 22 4.4128 22 5.5C22 6.5872 22 7.1308 21.8287 7.55959C21.6004 8.13133 21.1624 8.58557 20.611 8.82239C20.1976 9 19.6734 9 18.625 9H16.375C15.3266 9 14.8024 9 14.389 8.82239C13.8376 8.58557 13.3996 8.13133 13.1713 7.55959C13 7.1308 13 6.5872 13 5.5Z"
                                              fill="currentColor"></path>
                                          <path opacity="0.5"
                                              d="M2 18.5C2 19.5872 2 20.1308 2.17127 20.5596C2.39963 21.1313 2.83765 21.5856 3.38896 21.8224C3.80245 22 4.32663 22 5.375 22H7.625C8.67337 22 9.19755 22 9.61104 21.8224C10.1624 21.5856 10.6004 21.1313 10.8287 20.5596C11 20.1308 11 19.5872 11 18.5C11 17.4128 11 16.8692 10.8287 16.4404C10.6004 15.8687 10.1624 15.4144 9.61104 15.1776C9.19755 15 8.67337 15 7.625 15H5.375C4.32663 15 3.80245 15 3.38896 15.1776C2.83765 15.4144 2.39963 15.8687 2.17127 16.4404C2 16.8692 2 17.4128 2 18.5Z"
                                              fill="currentColor"></path>
                                      </svg>
                                      <span
                                          class="text-black ltr:pl-3 rtl:pr-3 dark:text-[#506690] dark:group-hover:text-white-dark">Setup</span>
                                  </div>
                                  <div class="rtl:rotate-180"
                                      :class="{ '!rotate-90': activeDropdown === 'setup' }">
                                      <svg width="16" height="16" viewbox="0 0 24 24" fill="none"
                                          xmlns="http://www.w3.org/2000/svg">
                                          <path d="M9 5L15 12L9 19" stroke="currentColor" stroke-width="1.5"
                                              stroke-linecap="round" stroke-linejoin="round"></path>
                                      </svg>
                                  </div>
                              </button>
                              <ul x-cloak="" x-show="activeDropdown === 'setup'" x-collapse=""
                                  class="sub-menu text-gray-500">
                                  <li>
                                      <a href="#">Employees</a>
                                  </li>
                                  <li>
                                      <a href="#">Ledger Accounts</a>
                                  </li>
                                  <li>
                                      <a href="#">VAT</a>
                                  </li>
                                  <li>
                                      <a href="#">Tax Groups</a>
                                  </li>
                                  <li>
                                      <a href="#">Customer Groups</a>
                                  </li>
                                  <li>
                                      <a href="#">Vendor Groups</a>
                                  </li>
                                  <li>
                                      <a class="{{ Request::is('admin/assets-update') ? 'active' : '' }}"
                                      href="{{ route('admin.AssetsUpdate') }}">Assets</a>
                                  </li>
                              </ul>
                          </li>
                          <li class="menu nav-item">
                              <button type="button" class="nav-link group"
                                  :class="{ 'active': activeDropdown === 'procurement' }"
                                  @click="activeDropdown === 'procurement' ? activeDropdown = null : activeDropdown = 'procurement'">
                                  <div class="flex items-center">
                                      <svg class="shrink-0 group-hover:!text-primary" width="20" height="20"
                                          viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"
                                          aria-label="Procurement Icon" role="img">
                                          <title>Procurement</title>
                                          <path opacity="0.5" fill-rule="evenodd" clip-rule="evenodd"
                                              d="M8.25 21C7.55964 21 7 21.5596 7 22.25C7 22.9404 7.55964 23.5 8.25 23.5C8.94036 23.5 9.5 22.9404 9.5 22.25C9.5 21.5596 8.94036 21 8.25 21ZM2.75 3C2.33579 3 2 3.33579 2 3.75C2 4.16421 2.33579 4.5 2.75 4.5H4.65267L7.34349 13.0272L6.246 15.9014C6.09166 16.3188 6.37786 16.75 6.8216 16.75H19.25C19.6642 16.75 20 16.4142 20 16C20 15.5858 19.6642 15.25 19.25 15.25H7.84585L8.66947 13.0272L17.5753 13.0288L20.4246 6.57575C20.6265 6.12658 20.3033 5.60856 19.8062 5.60204L5.6621 5.40634L5.13498 3.75261C5.05353 3.49595 4.79808 3 4.35748 3H2.75ZM17.25 21C16.5596 21 16 21.5596 16 22.25C16 22.9404 16.5596 23.5 17.25 23.5C17.9404 23.5 18.5 22.9404 18.5 22.25C18.5 21.5596 17.9404 21 17.25 21Z"
                                              fill="currentColor"></path>
                                      </svg>
                                      <span
                                          class="text-black ltr:pl-3 rtl:pr-3 dark:text-[#506690] dark:group-hover:text-white-dark">Procurement</span>
                                  </div>

                                  <div class="rtl:rotate-180"
                                      :class="{ '!rotate-90': activeDropdown === 'procurement' }">
                                      <svg width="16" height="16" viewbox="0 0 24 24" fill="none"
                                          xmlns="http://www.w3.org/2000/svg">
                                          <path d="M9 5L15 12L9 19" stroke="currentColor" stroke-width="1.5"
                                              stroke-linecap="round" stroke-linejoin="round"></path>
                                      </svg>
                                  </div>
                              </button>
                              <ul x-cloak="" x-show="activeDropdown === 'procurement'" x-collapse=""
                                  class="sub-menu text-gray-500">
                                  <li>
                                      <a href="#">Vendor</a>
                                  </li>
                                  <li>
                                      <a class="{{ Request::is('admin/purchase-order') ? 'active' : '' }}"
                                          href="{{ route('admin.PurchaseOrder') }}">Purchase Orders</a>
                                  </li>
                                  <li>
                                      <a class="{{ Request::is('admin/new-purchase-order') ? 'active' : '' }}"
                                          href="{{ route('admin.NewPurchaseOrder') }}">New Purchase</a>
                                  </li>

                                  <li>
                                      <a class="{{ Request::is('admin/packing-slip') ? 'active' : '' }}"
                                          href="{{ route('admin.PackingSlip') }}">New Packing Slip
                                      </a>
                                  </li>
                                  <li>
                                      <a href="#">Purchase Receive Note</a>
                                  </li>

                                  <li>
                                      <a class="{{ Request::is('admin/purchase-receive') ? 'active' : '' }}"
                                          href="{{ route('admin.PurchaseReceive') }}">New Purchase Receive</a>
                                  </li>
                              </ul>
                          </li>
                          <li class="menu nav-item">
                              <button type="button" class="nav-link group"
                                  :class="{ 'active': activeDropdown === 'production' }"
                                  @click="activeDropdown === 'production' ? activeDropdown = null : activeDropdown = 'production'">
                                  <div class="flex items-center">
                                      <svg class="shrink-0 group-hover:!text-primary" width="20" height="20"
                                          viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"
                                          aria-label="Production Icon" role="img">
                                          <title>Production</title>
                                          <path opacity="0.5" fill-rule="evenodd" clip-rule="evenodd"
                                              d="M12 2C12.5523 2 13 2.44772 13 3V4.128C14.1425 4.37145 15.2045 4.81354 16.1213 5.41421L17.2426 4.29289C17.6332 3.90237 18.2663 3.90237 18.6569 4.29289C19.0474 4.68342 19.0474 5.31658 18.6569 5.70711L17.5355 6.82843C18.1365 7.74548 18.5781 8.80855 18.8218 9.951V11H20C20.5523 11 21 11.4477 21 12C21 12.5523 20.5523 13 20 13H18.8218C18.5781 14.1425 18.1365 15.2045 17.5355 16.1213L18.6569 17.2426C19.0474 17.6332 19.0474 18.2663 18.6569 18.6569C18.2663 19.0474 17.6332 19.0474 17.2426 18.6569L16.1213 17.5355C15.2045 18.1365 14.1425 18.5781 13 18.8218V20C13 20.5523 12.5523 21 12 21C11.4477 21 11 20.5523 11 20V18.8218C9.85753 18.5781 8.79548 18.1365 7.87868 17.5355L6.75736 18.6569C6.36683 19.0474 5.73367 19.0474 5.34315 18.6569C4.95262 18.2663 4.95262 17.6332 5.34315 17.2426L6.46447 16.1213C5.86348 15.2045 5.4219 14.1425 5.1782 13H4C3.44772 13 3 12.5523 3 12C3 11.4477 3.44772 11 4 11H5.1782C5.4219 9.85753 5.86348 8.79548 6.46447 7.87868L5.34315 6.75736C4.95262 6.36683 4.95262 5.73367 5.34315 5.34315C5.73367 4.95262 6.36683 4.95262 6.75736 5.34315L7.87868 6.46447C8.79548 5.86348 9.85753 5.4219 11 5.1782V4C11 3.44772 11.4477 3 12 3ZM12 8C9.79086 8 8 9.79086 8 12C8 14.2091 9.79086 16 12 16C14.2091 16 16 14.2091 16 12C16 9.79086 14.2091 8 12 8Z"
                                              fill="currentColor"></path>
                                      </svg>
                                      <span
                                          class="text-black ltr:pl-3 rtl:pr-3 dark:text-[#506690] dark:group-hover:text-white-dark">Production</span>
                                  </div>

                                  <div class="rtl:rotate-180"
                                      :class="{ '!rotate-90': activeDropdown === 'production' }">
                                      <svg width="16" height="16" viewbox="0 0 24 24" fill="none"
                                          xmlns="http://www.w3.org/2000/svg">
                                          <path d="M9 5L15 12L9 19" stroke="currentColor" stroke-width="1.5"
                                              stroke-linecap="round" stroke-linejoin="round"></path>
                                      </svg>
                                  </div>
                              </button>
                              <ul x-cloak="" x-show="activeDropdown === 'production'" x-collapse=""
                                  class="sub-menu text-gray-500">
                                  <li>
                                      <a class="{{ Request::is('admin/production-requests') ? 'active' : '' }}"
                                          href="{{ route('admin.ProductionRequest') }}">Production Request</a>
                                  </li>
                                  <li>
                                      <a class="{{ Request::is('admin/production-order-request') ? 'active' : '' }}"
                                          href="{{ route('admin.ProductionOrderRequest') }}">New Request</a>
                                  </li>
                                  <li>
                                      <a href="#">Production Orders</a>
                                  </li>
                                  <li>
                                      <a class="{{ Request::is('admin/production-order') ? 'active' : '' }}"
                                          href="{{ route('admin.ProductionOrder') }}">New Production</a>
                                  </li>
                              </ul>
                          </li>
                          <li class="menu nav-item">
                              <button type="button" class="nav-link group"
                                  :class="{ 'active': activeDropdown === 'sales' }"
                                  @click="activeDropdown === 'sales' ? activeDropdown = null : activeDropdown = 'sales'">
                                  <div class="flex items-center">
                                      <svg class="shrink-0 group-hover:!text-primary" width="20" height="20"
                                          viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"
                                          aria-label="Sales Icon" role="img">
                                          <title>Sales</title> <!-- Tooltip for accessibility -->
                                          <path opacity="0.5" fill-rule="evenodd" clip-rule="evenodd"
                                              d="M22 12C22 17.5228 17.5228 22 12 22C6.47715 22 2 17.5228 2 12C2 6.47715 6.47715 2 12 2C17.5228 2 22 6.47715 22 12Z"
                                              fill="currentColor"></path>
                                          <path fill-rule="evenodd" clip-rule="evenodd"
                                              d="M12 5.25C12.4142 5.25 12.75 5.58579 12.75 6V6.31673C14.3804 6.60867 15.75 7.83361 15.75 9.5C15.75 9.91421 15.4142 10.25 15 10.25C14.5858 10.25 14.25 9.91421 14.25 9.5C14.25 8.82154 13.6859 8.10339 12.75 7.84748V11.3167C14.3804 11.6087 15.75 12.8336 15.75 14.5C15.75 16.1664 14.3804 17.3913 12.75 17.6833V18C12.75 18.4142 12.4142 18.75 12 18.75C11.5858 18.75 11.25 18.4142 11.25 18V17.6833C9.61957 17.3913 8.25 16.1664 8.25 14.5C8.25 14.0858 8.58579 13.75 9 13.75C9.41421 13.75 9.75 14.0858 9.75 14.5C9.75 15.1785 10.3141 15.8966 11.25 16.1525V12.6833C9.61957 12.3913 8.25 11.1664 8.25 9.5C8.25 7.83361 9.61957 6.60867 11.25 6.31673V6C11.25 5.58579 11.5858 5.25 12 5.25ZM11.25 7.84748C10.3141 8.10339 9.75 8.82154 9.75 9.5C9.75 10.1785 10.3141 10.8966 11.25 11.1525V7.84748ZM14.25 14.5C14.25 13.8215 13.6859 13.1034 12.75 12.8475V16.1525C13.6859 15.8966 14.25 15.1785 14.25 14.5Z"
                                              fill="currentColor"></path>
                                      </svg>
                                      <span
                                          class="text-black ltr:pl-3 rtl:pr-3 dark:text-[#506690] dark:group-hover:text-white-dark">Sales</span>
                                  </div>

                                  <div class="rtl:rotate-180"
                                      :class="{ '!rotate-90': activeDropdown === 'sales' }">
                                      <svg width="16" height="16" viewbox="0 0 24 24" fill="none"
                                          xmlns="http://www.w3.org/2000/svg">
                                          <path d="M9 5L15 12L9 19" stroke="currentColor" stroke-width="1.5"
                                              stroke-linecap="round" stroke-linejoin="round"></path>
                                      </svg>
                                  </div>
                              </button>
                              <ul x-cloak="" x-show="activeDropdown === 'sales'" x-collapse=""
                                  class="sub-menu text-gray-500">
                                  <li>
                                      <a class="{{ Request::is('admin/customer-management') ? 'active' : '' }}"
                                          href="{{ route('admin.CustomerManagement') }}">Customer</a>
                                  </li>
                                  <li>
                                      <a href="#">Sales Quotations</a>
                                  </li>
                                  <li>
                                      <a href="#">New Sales Quotations </a>
                                  </li>
                                  <li>
                                      <a href="#">Sales Orders</a>
                                  </li>
                                  <li>
                                      <a href="#">New Sales Orders</a>
                                  </li>
                                  <li>
                                      <a href="#">New Pick List</a>
                                  </li>
                                  <li>
                                      <a href="#">Sales Delivery Note</a>
                                  </li>
                                  <li>
                                      <a href="#">New Sales Delivery</a>
                                  </li>
                                  <li>
                                      <a href="#">New Direct Sales Invoice</a>
                                  </li>
                              </ul>
                          </li>
                          <li class="menu nav-item">
                              <button type="button" class="nav-link group"
                                  :class="{ 'active': activeDropdown === 'inventory' }"
                                  @click="activeDropdown === 'inventory' ? activeDropdown = null : activeDropdown = 'inventory'">
                                  <div class="flex items-center">
                                      <svg class="shrink-0 group-hover:!text-primary" width="20" height="20"
                                          viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                          <path
                                              d="M8.42229 20.6181C10.1779 21.5395 11.0557 22.0001 12 22.0001V12.0001L2.63802 7.07275C2.62423 7.09491 2.6107 7.11727 2.5974 7.13986C2 8.15436 2 9.41678 2 11.9416V12.0586C2 14.5834 2 15.8459 2.5974 16.8604C3.19479 17.8749 4.27063 18.4395 6.42229 19.5686L8.42229 20.6181Z"
                                              fill="currentColor"></path>
                                          <path opacity="0.7"
                                              d="M17.5774 4.43152L15.5774 3.38197C13.8218 2.46066 12.944 2 11.9997 2C11.0554 2 10.1776 2.46066 8.42197 3.38197L6.42197 4.43152C4.31821 5.53552 3.24291 6.09982 2.6377 7.07264L11.9997 12L21.3617 7.07264C20.7564 6.09982 19.6811 5.53552 17.5774 4.43152Z"
                                              fill="currentColor"></path>
                                          <path opacity="0.5"
                                              d="M21.4026 7.13986C21.3893 7.11727 21.3758 7.09491 21.362 7.07275L12 12.0001V22.0001C12.9443 22.0001 13.8221 21.5395 15.5777 20.6181L17.5777 19.5686C19.7294 18.4395 20.8052 17.8749 21.4026 16.8604C22 15.8459 22 14.5834 22 12.0586V11.9416C22 9.41678 22 8.15436 21.4026 7.13986Z"
                                              fill="currentColor"></path>
                                      </svg>
                                      <span
                                          class="text-black ltr:pl-3 rtl:pr-3 dark:text-[#506690] dark:group-hover:text-white-dark">Inventory</span>
                                  </div>
                                  <div class="rtl:rotate-180"
                                      :class="{ '!rotate-90': activeDropdown === 'inventory' }">
                                      <svg width="16" height="16" viewbox="0 0 24 24" fill="none"
                                          xmlns="http://www.w3.org/2000/svg">
                                          <path d="M9 5L15 12L9 19" stroke="currentColor" stroke-width="1.5"
                                              stroke-linecap="round" stroke-linejoin="round"></path>
                                      </svg>
                                  </div>
                              </button>
                              <ul x-show="activeDropdown === 'inventory'" x-collapse=""
                                  class="sub-menu text-gray-500" style="height: auto;">
                                  <li>
                                      <a class="{{ Request::is('admin/warehouses') ? 'active' : '' }}"
                                          href="{{ route('admin.warehouses') }}">Warehouses</a>
                                  </li>
                                  <li>
                                      <a class="{{ Request::is('admin/transfer-request') ? 'active' : '' }}"
                                          href="{{ route('admin.transferRequest') }}">Transfer Request</a>
                                  </li>
                                  <li>
                                      <a class="" href="#">Transfer Receives</a>
                                  </li>
                                  <li>
                                      <a class="" href="#">Transfer Issues</a>
                                  </li>
                                  <li>
                                      <a class="" href="#">New Transfer Request </a>
                                  </li>
                                  <li>
                                      <a class="" href="#">Transfer Orders</a>
                                  </li>
                                  <li>
                                      <a class="" href="#">Transfer Journal</a>
                                  </li>
                                  <li>
                                      <a class="{{ Request::is('admin/update-onHand') ? 'active' : '' }}"
                                          href="{{ route('admin.UpdateOnHand') }}">OnHand Update</a>
                                  </li>
                                  <li>
                                      <a class="{{ Request::is('admin/transfer-issue') ? 'active' : '' }}"
                                          href="{{ route('admin.TIssueQtfDiff') }}">Transfer Issue Qtf Diff</a>
                                  </li>
                                  <li>
                                      <a class="{{ Request::is('admin/transfer-receive') ? 'active' : '' }}"
                                          href="{{ route('admin.TRecQtfDiff') }}">Transfer Receives Qtf Diff</a>
                                  </li>

                              </ul>
                          </li>
                          <li class="menu nav-item">
                              <button type="button" class="nav-link group"
                                  :class="{ 'active': activeDropdown === 'ledger' }"
                                  @click="activeDropdown === 'ledger' ? activeDropdown = null : activeDropdown = 'ledger'">
                                  <div class="flex items-center">
                                      <svg class="shrink-0 group-hover:!text-primary" width="20" height="20"
                                          viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                          <path
                                              d="M4.97883 9.68508C2.99294 8.89073 2 8.49355 2 8C2 7.50645 2.99294 7.10927 4.97883 6.31492L7.7873 5.19153C9.77318 4.39718 10.7661 4 12 4C13.2339 4 14.2268 4.39718 16.2127 5.19153L19.0212 6.31492C21.0071 7.10927 22 7.50645 22 8C22 8.49355 21.0071 8.89073 19.0212 9.68508L16.2127 10.8085C14.2268 11.6028 13.2339 12 12 12C10.7661 12 9.77318 11.6028 7.7873 10.8085L4.97883 9.68508Z"
                                              fill="currentColor"></path>
                                          <path fill-rule="evenodd" clip-rule="evenodd"
                                              d="M2 8C2 8.49355 2.99294 8.89073 4.97883 9.68508L7.7873 10.8085C9.77318 11.6028 10.7661 12 12 12C13.2339 12 14.2268 11.6028 16.2127 10.8085L19.0212 9.68508C21.0071 8.89073 22 8.49355 22 8C22 7.50645 21.0071 7.10927 19.0212 6.31492L16.2127 5.19153C14.2268 4.39718 13.2339 4 12 4C10.7661 4 9.77318 4.39718 7.7873 5.19153L4.97883 6.31492C2.99294 7.10927 2 7.50645 2 8Z"
                                              fill="currentColor"></path>
                                          <path opacity="0.7"
                                              d="M5.76613 10L4.97883 10.3149C2.99294 11.1093 2 11.5065 2 12C2 12.4935 2.99294 12.8907 4.97883 13.6851L7.7873 14.8085C9.77318 15.6028 10.7661 16 12 16C13.2339 16 14.2268 15.6028 16.2127 14.8085L19.0212 13.6851C21.0071 12.8907 22 12.4935 22 12C22 11.5065 21.0071 11.1093 19.0212 10.3149L18.2339 10L16.2127 10.8085C14.2268 11.6028 13.2339 12 12 12C10.7661 12 9.77318 11.6028 7.7873 10.8085L5.76613 10Z"
                                              fill="currentColor"></path>
                                          <path opacity="0.4"
                                              d="M5.76613 14L4.97883 14.3149C2.99294 15.1093 2 15.5065 2 16C2 16.4935 2.99294 16.8907 4.97883 17.6851L7.7873 18.8085C9.77318 19.6028 10.7661 20 12 20C13.2339 20 14.2268 19.6028 16.2127 18.8085L19.0212 17.6851C21.0071 16.8907 22 16.4935 22 16C22 15.5065 21.0071 15.1093 19.0212 14.3149L18.2339 14L16.2127 14.8085C14.2268 15.6028 13.2339 16 12 16C10.7661 16 9.77318 15.6028 7.7873 14.8085L5.76613 14Z"
                                              fill="currentColor"></path>
                                      </svg>
                                      <span
                                          class="text-black ltr:pl-3 rtl:pr-3 dark:text-[#506690] dark:group-hover:text-white-dark">Ledger</span>
                                  </div>
                                  <div class="rtl:rotate-180"
                                      :class="{ '!rotate-90': activeDropdown === 'ledger' }">
                                      <svg width="16" height="16" viewbox="0 0 24 24" fill="none"
                                          xmlns="http://www.w3.org/2000/svg">
                                          <path d="M9 5L15 12L9 19" stroke="currentColor" stroke-width="1.5"
                                              stroke-linecap="round" stroke-linejoin="round"></path>
                                      </svg>
                                  </div>
                              </button>
                              <ul x-cloak="" x-show="activeDropdown === 'ledger'" x-collapse=""
                                  class="sub-menu text-gray-500">
                                  <li>
                                      <a class="{{ Request::is('admin/payment-voucher') ? 'active' : '' }}"
                                          href="{{ route('admin.paymentVoucher') }}">Payment Voucher</a>
                                  </li>
                                  <li>
                                      <a href="#">General Voucher</a>
                                  </li>
                                  <li>
                                      <a href="#">Receipt Voucher</a>
                                  </li>
                                  <li>
                                      <a href="#">Settle SO</a>
                                  </li>
                                  <li>
                                      <a href="#">Settle PO</a>
                                  </li>
                              </ul>
                          </li>
                          <li class="menu nav-item">
                              <button type="button" class="nav-link group"
                                  :class="{ 'active': activeDropdown === 'reports' }"
                                  @click="activeDropdown === 'reports' ? activeDropdown = null : activeDropdown = 'reports'">
                                  <div class="flex items-center">
                                      <svg class="shrink-0 group-hover:!text-primary" width="20" height="20"
                                          viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                          <path opacity="0.5"
                                              d="M3 10C3 6.22876 3 4.34315 4.17157 3.17157C5.34315 2 7.22876 2 11 2H13C16.7712 2 18.6569 2 19.8284 3.17157C21 4.34315 21 6.22876 21 10V14C21 17.7712 21 19.6569 19.8284 20.8284C18.6569 22 16.7712 22 13 22H11C7.22876 22 5.34315 22 4.17157 20.8284C3 19.6569 3 17.7712 3 14V10Z"
                                              fill="currentColor"></path>
                                          <path fill-rule="evenodd" clip-rule="evenodd"
                                              d="M7.25 12C7.25 11.5858 7.58579 11.25 8 11.25H16C16.4142 11.25 16.75 11.5858 16.75 12C16.75 12.4142 16.4142 12.75 16 12.75H8C7.58579 12.75 7.25 12.4142 7.25 12Z"
                                              fill="currentColor"></path>
                                          <path fill-rule="evenodd" clip-rule="evenodd"
                                              d="M7.25 8C7.25 7.58579 7.58579 7.25 8 7.25H16C16.4142 7.25 16.75 7.58579 16.75 8C16.75 8.41421 16.4142 8.75 16 8.75H8C7.58579 8.75 7.25 8.41421 7.25 8Z"
                                              fill="currentColor"></path>
                                          <path fill-rule="evenodd" clip-rule="evenodd"
                                              d="M7.25 16C7.25 15.5858 7.58579 15.25 8 15.25H13C13.4142 15.25 13.75 15.5858 13.75 16C13.75 16.4142 13.4142 16.75 13 16.75H8C7.58579 16.75 7.25 16.4142 7.25 16Z"
                                              fill="currentColor"></path>
                                      </svg>
                                      <span
                                          class="text-black ltr:pl-3 rtl:pr-3 dark:text-[#506690] dark:group-hover:text-white-dark">Reports</span>
                                  </div>
                                  <div class="rtl:rotate-180"
                                      :class="{ '!rotate-90': activeDropdown === 'reports' }">
                                      <svg width="16" height="16" viewbox="0 0 24 24" fill="none"
                                          xmlns="http://www.w3.org/2000/svg">
                                          <path d="M9 5L15 12L9 19" stroke="currentColor" stroke-width="1.5"
                                              stroke-linecap="round" stroke-linejoin="round"></path>
                                      </svg>
                                  </div>
                              </button>
                              <ul x-cloak="" x-show="activeDropdown === 'reports'" x-collapse=""
                                  class="sub-menu text-gray-500">
                                  <li>
                                      <a href="#">List</a>
                                  </li>
                                  <li>
                                      <a href="#">view</a>
                                  </li>
                                  <li>
                                      <a href="#">edit</a>
                                  </li>
                              </ul>
                          </li>
                          <li class="menu nav-item">
                              <button type="button" class="nav-link group"
                                  :class="{ 'active': activeDropdown === 'document' }"
                                  @click="activeDropdown === 'document' ? activeDropdown = null : activeDropdown = 'document'">
                                  <div class="flex items-center">
                                      <svg class="shrink-0 group-hover:!text-primary" width="20" height="20"
                                          viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                          <path opacity="0.5"
                                              d="M3 10C3 6.22876 3 4.34315 4.17157 3.17157C5.34315 2 7.22876 2 11 2H13C16.7712 2 18.6569 2 19.8284 3.17157C21 4.34315 21 6.22876 21 10V14C21 17.7712 21 19.6569 19.8284 20.8284C18.6569 22 16.7712 22 13 22H11C7.22876 22 5.34315 22 4.17157 20.8284C3 19.6569 3 17.7712 3 14V10Z"
                                              fill="currentColor"></path>
                                          <path
                                              d="M16.5189 16.5013C16.6939 16.3648 16.8526 16.2061 17.1701 15.8886L21.1275 11.9312C21.2231 11.8356 21.1793 11.6708 21.0515 11.6264C20.5844 11.4644 19.9767 11.1601 19.4083 10.5917C18.8399 10.0233 18.5356 9.41561 18.3736 8.94849C18.3292 8.82066 18.1644 8.77687 18.0688 8.87254L14.1114 12.8299C13.7939 13.1474 13.6352 13.3061 13.4987 13.4811C13.3377 13.6876 13.1996 13.9109 13.087 14.1473C12.9915 14.3476 12.9205 14.5606 12.7786 14.9865L12.5951 15.5368L12.3034 16.4118L12.0299 17.2323C11.9601 17.4419 12.0146 17.6729 12.1708 17.8292C12.3271 17.9854 12.5581 18.0399 12.7677 17.9701L13.5882 17.6966L14.4632 17.4049L15.0135 17.2214L15.0136 17.2214C15.4394 17.0795 15.6524 17.0085 15.8527 16.913C16.0891 16.8004 16.3124 16.6623 16.5189 16.5013Z"
                                              fill="currentColor"></path>
                                          <path
                                              d="M22.3665 10.6922C23.2112 9.84754 23.2112 8.47812 22.3665 7.63348C21.5219 6.78884 20.1525 6.78884 19.3078 7.63348L19.1806 7.76071C19.0578 7.88348 19.0022 8.05496 19.0329 8.22586C19.0522 8.33336 19.0879 8.49053 19.153 8.67807C19.2831 9.05314 19.5288 9.54549 19.9917 10.0083C20.4545 10.4712 20.9469 10.7169 21.3219 10.847C21.5095 10.9121 21.6666 10.9478 21.7741 10.9671C21.945 10.9978 22.1165 10.9422 22.2393 10.8194L22.3665 10.6922Z"
                                              fill="currentColor"></path>
                                          <path fill-rule="evenodd" clip-rule="evenodd"
                                              d="M7.25 9C7.25 8.58579 7.58579 8.25 8 8.25H14.5C14.9142 8.25 15.25 8.58579 15.25 9C15.25 9.41421 14.9142 9.75 14.5 9.75H8C7.58579 9.75 7.25 9.41421 7.25 9ZM7.25 13C7.25 12.5858 7.58579 12.25 8 12.25H11C11.4142 12.25 11.75 12.5858 11.75 13C11.75 13.4142 11.4142 13.75 11 13.75H8C7.58579 13.75 7.25 13.4142 7.25 13ZM7.25 17C7.25 16.5858 7.58579 16.25 8 16.25H9.5C9.91421 16.25 10.25 16.5858 10.25 17C10.25 17.4142 9.91421 17.75 9.5 17.75H8C7.58579 17.75 7.25 17.4142 7.25 17Z"
                                              fill="currentColor"></path>
                                      </svg>
                                      <span
                                          class="text-black ltr:pl-3 rtl:pr-3 dark:text-[#506690] dark:group-hover:text-white-dark">Document</span>
                                  </div>
                                  <div class="rtl:rotate-180"
                                      :class="{ '!rotate-90': activeDropdown === 'document' }">
                                      <svg width="16" height="16" viewbox="0 0 24 24" fill="none"
                                          xmlns="http://www.w3.org/2000/svg">
                                          <path d="M9 5L15 12L9 19" stroke="currentColor" stroke-width="1.5"
                                              stroke-linecap="round" stroke-linejoin="round"></path>
                                      </svg>
                                  </div>
                              </button>
                              <ul x-cloak="" x-show="activeDropdown === 'document'" x-collapse=""
                                  class="sub-menu text-gray-500">
                                  <li>
                                      <a href="#">List</a>
                                  </li>
                                  <li>
                                      <a href="#">view</a>
                                  </li>
                                  <li>
                                      <a href="#">edit</a>
                                  </li>
                              </ul>
                          </li>


                          <li class="nav-item">
                              <a href="apps-calendar.html" class="group">
                                  <div class="flex items-center">
                                      <svg class="shrink-0 group-hover:!text-primary" width="20" height="20"
                                          viewbox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                          <path
                                              d="M6.94028 2C7.35614 2 7.69326 2.32421 7.69326 2.72414V4.18487C8.36117 4.17241 9.10983 4.17241 9.95219 4.17241H13.9681C14.8104 4.17241 15.5591 4.17241 16.227 4.18487V2.72414C16.227 2.32421 16.5641 2 16.98 2C17.3958 2 17.733 2.32421 17.733 2.72414V4.24894C19.178 4.36022 20.1267 4.63333 20.8236 5.30359C21.5206 5.97385 21.8046 6.88616 21.9203 8.27586L22 9H2.92456H2V8.27586C2.11571 6.88616 2.3997 5.97385 3.09665 5.30359C3.79361 4.63333 4.74226 4.36022 6.1873 4.24894V2.72414C6.1873 2.32421 6.52442 2 6.94028 2Z"
                                              fill="currentColor"></path>
                                          <path opacity="0.5"
                                              d="M21.9995 14.0001V12.0001C21.9995 11.161 21.9963 9.66527 21.9834 9H2.00917C1.99626 9.66527 1.99953 11.161 1.99953 12.0001V14.0001C1.99953 17.7713 1.99953 19.6569 3.1711 20.8285C4.34267 22.0001 6.22829 22.0001 9.99953 22.0001H13.9995C17.7708 22.0001 19.6564 22.0001 20.828 20.8285C21.9995 19.6569 21.9995 17.7713 21.9995 14.0001Z"
                                              fill="currentColor"></path>
                                      </svg>
                                      <span
                                          class="text-black ltr:pl-3 rtl:pr-3 dark:text-[#506690] dark:group-hover:text-white-dark">Help</span>
                                  </div>
                              </a>
                          </li>
                      </ul>
                  </li>


              </ul>
          </div>
      </nav>
  </div>

  <!-- end sidebar section -->
