@extends('admin.layouts.app')
@section('content')
    <div>
        <ul class="flex space-x-2 rtl:space-x-reverse">
            <li>
                <a href="{{ route('admin.dashboard') }}" class="text-primary hover:underline">Dashboard</a>
            </li>
            <li class="before:content-['/'] ltr:before:mr-1 rtl:before:ml-1">
                <span>Payment Voucher</span>
            </li>
        </ul>
    </div>
    <div class="pt-5">
        <!-- Voucher Header Section -->
        <div class="panel mb-4">
            <div class="mb-5 flex items-center justify-between">
                <h5 class="text-lg font-semibold dark:text-white-light">Voucher Header</h5>
            </div>
            <form class="space-y-5">
                <div class="grid grid-cols-1 gap-4 sm:grid-cols-3">
                    <div>
                        <label for="journalId">Journal ID</label>
                        <input id="journalId" type="text" placeholder="Journal ID" class="form-input" disabled>
                    </div>
                    <div>
                        <label for="journalName">Name</label>
                        <input id="journalName" type="text" placeholder="Journal Name" class="form-input">
                    </div>
                    <div>
                        <label for="date">Date</label>
                        <input id="date" type="text" placeholder="Date" class="form-input">
                    </div>
                    <div>
                        <label for="purchRef">Purchase Ref</label>
                        <select id="purchRef" class="form-select">
                            <option>Select Reference</option>
                            <!-- Additional options can be added here -->
                        </select>
                    </div>
                    <div>
                        <label for="salesRef">Sales Ref</label>
                        <select id="salesRef" class="form-select">
                            <option>Select Sales Ref</option>
                            <!-- Additional options can be added here -->
                        </select>
                    </div>
                    <div>
                        <label for="notes">Notes</label>
                        <textarea id="notes" placeholder="Enter..." class="form-input"></textarea>
                    </div>
                </div>
            </form>
        </div>

        <!-- Audit Details Section -->
        <div class="panel mb-4">
            <div class="mb-5 flex items-center justify-between">
                <h5 class="text-lg font-semibold dark:text-white-light">Audit Details</h5>
            </div>
            <form class="space-y-5">
                <div class="grid grid-cols-1 gap-4 sm:grid-cols-2">
                    <div>
                        <label for="createdDatetime">Date</label>
                        <input id="createdDatetime" type="text" placeholder="Created Datetime" class="form-input"
                            disabled>
                    </div>
                    <div>
                        <label for="createdBy">User</label>
                        <input id="createdBy" type="text" placeholder="Created By" class="form-input" disabled>
                    </div>
                </div>
            </form>
        </div>

        <!-- Payment Information Section -->
        <div class="panel mb-4">
            <div class="mb-5 flex items-center justify-between">
                <h5 class="text-lg font-semibold dark:text-white-light">Payment Information</h5>
            </div>
            <form class="space-y-5">
                <div class="grid grid-cols-1 gap-4 sm:grid-cols-3">
                    <div>
                        <label for="debitAccount">Debit Account</label>
                        <select id="debitAccount" class="form-select">
                            <option>Select Debit Account</option>
                            <!-- Additional options can be added here -->
                        </select>
                    </div>
                    <div>
                        <label for="debitAmount">Debit Amount</label>
                        <div class="flex">
                            <button type="button" class="btn btn-info ltr:rounded-r-none rtl:rounded-l-none">AMT</button>
                            <input  type="text"  class="form-input ltr:rounded-l-none rtl:rounded-r-none">
                            <button type="button" class="btn btn-outline-secondary ltr:rounded-l-none rtl:rounded-r-none">
                                .00
                            </button>
                        </div>
                    </div>
                    <div>
                        <label for="creditAccount">Credit Account</label>
                        <select id="creditAccount" class="form-select">
                            <option>Select Credit Account</option>
                            <!-- Additional options can be added here -->
                        </select>
                    </div>
                    <div>
                        <label for="creditAmount">Credit Amount</label>
                        <div class="flex">
                            <button type="button" class="btn btn-info ltr:rounded-r-none rtl:rounded-l-none">AMT</button>
                            <input  type="text"  class="form-input ltr:rounded-l-none rtl:rounded-r-none">
                            <button type="button" class="btn btn-outline-secondary ltr:rounded-l-none rtl:rounded-r-none">
                                .00
                            </button>
                        </div>
                    </div>
                </div>
                <div class="flex justify-end">
                    <button type="submit" class="btn btn-primary">Submit</button>
                </div>
            </form>
        </div>
    </div>
@endsection
