@extends('admin.layouts.app')
@section('content')
    <div>
        <ul class="flex space-x-2 rtl:space-x-reverse">
            <li>
                <a href="{{ route('admin.dashboard') }}" class="text-primary hover:underline">Dashboard</a>
            </li>
            <li class="before:content-['/'] ltr:before:mr-1 rtl:before:ml-1">
                <span>Transfer Request</span>
            </li>
        </ul>

    </div>
    <div class="pt-5">
        <div class="panel mb-4">
            <!-- Transfer Header Section -->
            <div class="mb-5 flex items-center justify-between">
                <h5 class="text-lg font-semibold dark:text-white-light">Transfer Header</h5>
            </div>
            <div class="mb-5">
                <form class="space-y-5">
                    <div class="grid grid-cols-1 gap-4 sm:grid-cols-3">
                        <div>
                            <label for="transferId">Transfer ID</label>
                            <input id="transferId" type="text" placeholder="Transfer ID" class="form-input" disabled>
                        </div>
                        <div>
                            <label for="transferName">Name</label>
                            <input id="transferName" type="text" placeholder="Transfer Name" class="form-input">
                        </div>
                        <div>
                            <label for="reference">Reference</label>
                            <input id="reference" type="text" placeholder="Reference" class="form-input">
                        </div>
                        <div>
                            <label for="notes">Notes</label>
                            <textarea id="notes" placeholder="Enter..." class="form-input"></textarea>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        <div class="panel mb-4">
            <!-- Transfer Info Section -->
            <div class="mb-5 flex items-center justify-between">
                <h5 class="text-lg font-semibold dark:text-white-light">Transfer Info</h5>
            </div>
            <div class="mb-5">
                <form class="space-y-5">
                    <div class="grid grid-cols-1 gap-4 sm:grid-cols-2">
                        <div>
                            <label for="fromWarehouse">From Warehouse</label>
                            <select id="fromWarehouse" class="form-select">
                                <option>Central Warehouse</option>
                                <!-- Add other options as needed -->
                            </select>
                        </div>
                        <div>
                            <label for="toWarehouse">To Warehouse</label>
                            <select id="toWarehouse" class="form-select">
                                <option>Central Warehouse</option>
                                <!-- Add other options as needed -->
                            </select>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        <div class="panel">
            <!-- Creation Details Section -->
            <div class="mb-5 flex items-center justify-between">
                <h5 class="text-lg font-semibold dark:text-white-light">Creation Details</h5>
            </div>
            <div class="mb-5">
                <form class="space-y-5">
                    <div class="grid grid-cols-1 gap-4 sm:grid-cols-2">
                        <div>
                            <label for="createdDate">Created Date</label>
                            <input id="createdDate" type="text" placeholder="Created Datetime" class="form-input"
                                disabled>
                        </div>
                        <div>
                            <label for="createdBy">Created By</label>
                            <input id="createdBy" type="text" placeholder="Created By" class="form-input" disabled>
                        </div>
                        <div>
                            <label for="modifiedDate">Modified Date</label>
                            <input id="modifiedDate" type="text" placeholder="Modified Datetime" class="form-input"
                                disabled>
                        </div>
                        <div>
                            <label for="modifiedBy">Modified By</label>
                            <input id="modifiedBy" type="text" placeholder="Modified By" class="form-input" disabled>
                        </div>
                    </div>
                    <div class="flex justify-end">
                        <a class="btn btn-primary" href="{{ route('admin.InvoiceTransferReq') }}">Submit</a>
                    </div>
                </form>
            </div>

        </div>

    </div>
@endsection
