@extends('admin.layouts.app')
@section('content')
    <div>
        <ul class="flex space-x-2 rtl:space-x-reverse">
            <li>
                <a href="{{ route('admin.dashboard') }}" class="text-primary hover:underline">Dashboard</a>
            </li>
            <li class="before:content-['/'] ltr:before:mr-1 rtl:before:ml-1">
                <span>Warehouses List</span>
            </li>
        </ul>
        <div class="grid grid-cols-1 gap-6 xl:grid-cols-2" x-data="form">

            <div class="pt-5">


                <div class="grid grid-cols-1 gap-6 xl:grid-cols-1">
                    <div class="panel">

                        <div class="mb-5">
                            <div class="table-responsive">
                                <table>
                                    <thead>
                                        <tr>
                                            <th>Warehouse </th>
                                            <th>Warehouse Name </th>
                                            <th class="!text-center">Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>

                                        <tr>
                                            <td class="whitespace-nowrap">101</td>
                                            <td>Central Warehouse</td>

                                            <td class="text-center">
                                                <ul class="flex items-center justify-center gap-2">
                                                    <li>
                                                        <a href="javascript:;" x-tooltip="Edit">
                                                            <svg width="24" height="24" viewBox="0 0 24 24"
                                                                fill="none" xmlns="http://www.w3.org/2000/svg"
                                                                class="h-5 w-5 text-primary">
                                                                <circle opacity="0.5" cx="12" cy="12" r="10"
                                                                    stroke="currentColor" stroke-width="1.5">
                                                                </circle>
                                                                <path d="M8.5 12.5L10.5 14.5L15.5 9.5" stroke="currentColor"
                                                                    stroke-width="1.5" stroke-linecap="round"
                                                                    stroke-linejoin="round">
                                                                </path>
                                                            </svg>
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a href="javascript:;" x-tooltip="Delete">
                                                            <svg width="24" height="24" viewBox="0 0 24 24"
                                                                fill="none" xmlns="http://www.w3.org/2000/svg"
                                                                class="h-5 w-5 text-danger">
                                                                <circle opacity="0.5" cx="12" cy="12" r="10"
                                                                    stroke="currentColor" stroke-width="1.5">
                                                                </circle>
                                                                <path d="M14.5 9.50002L9.5 14.5M9.49998 9.5L14.5 14.5"
                                                                    stroke="currentColor" stroke-width="1.5"
                                                                    stroke-linecap="round">
                                                                </path>
                                                            </svg>
                                                        </a>
                                                    </li>
                                                </ul>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="whitespace-nowrap">102</td>
                                            <td>Sales Warehouse</td>

                                            <td class="text-center">
                                                <ul class="flex items-center justify-center gap-2">
                                                    <li>
                                                        <a href="javascript:;" x-tooltip="Edit">
                                                            <svg width="24" height="24" viewBox="0 0 24 24"
                                                                fill="none" xmlns="http://www.w3.org/2000/svg"
                                                                class="h-5 w-5 text-primary">
                                                                <circle opacity="0.5" cx="12" cy="12" r="10"
                                                                    stroke="currentColor" stroke-width="1.5">
                                                                </circle>
                                                                <path d="M8.5 12.5L10.5 14.5L15.5 9.5" stroke="currentColor"
                                                                    stroke-width="1.5" stroke-linecap="round"
                                                                    stroke-linejoin="round">
                                                                </path>
                                                            </svg>
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a href="javascript:;" x-tooltip="Delete">
                                                            <svg width="24" height="24" viewBox="0 0 24 24"
                                                                fill="none" xmlns="http://www.w3.org/2000/svg"
                                                                class="h-5 w-5 text-danger">
                                                                <circle opacity="0.5" cx="12" cy="12" r="10"
                                                                    stroke="currentColor" stroke-width="1.5">
                                                                </circle>
                                                                <path d="M14.5 9.50002L9.5 14.5M9.49998 9.5L14.5 14.5"
                                                                    stroke="currentColor" stroke-width="1.5"
                                                                    stroke-linecap="round">
                                                                </path>
                                                            </svg>
                                                        </a>
                                                    </li>
                                                </ul>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="whitespace-nowrap">103</td>
                                            <td>Purchase Warehouse</td>

                                            <td class="text-center">
                                                <ul class="flex items-center justify-center gap-2">
                                                    <li>
                                                        <a href="javascript:;" x-tooltip="Edit">
                                                            <svg width="24" height="24" viewBox="0 0 24 24"
                                                                fill="none" xmlns="http://www.w3.org/2000/svg"
                                                                class="h-5 w-5 text-primary">
                                                                <circle opacity="0.5" cx="12" cy="12" r="10"
                                                                    stroke="currentColor" stroke-width="1.5">
                                                                </circle>
                                                                <path d="M8.5 12.5L10.5 14.5L15.5 9.5"
                                                                    stroke="currentColor" stroke-width="1.5"
                                                                    stroke-linecap="round" stroke-linejoin="round">
                                                                </path>
                                                            </svg>
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a href="javascript:;" x-tooltip="Delete">
                                                            <svg width="24" height="24" viewBox="0 0 24 24"
                                                                fill="none" xmlns="http://www.w3.org/2000/svg"
                                                                class="h-5 w-5 text-danger">
                                                                <circle opacity="0.5" cx="12" cy="12"
                                                                    r="10" stroke="currentColor" stroke-width="1.5">
                                                                </circle>
                                                                <path d="M14.5 9.50002L9.5 14.5M9.49998 9.5L14.5 14.5"
                                                                    stroke="currentColor" stroke-width="1.5"
                                                                    stroke-linecap="round">
                                                                </path>
                                                            </svg>
                                                        </a>
                                                    </li>
                                                </ul>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="whitespace-nowrap">104</td>
                                            <td>Jeddah Warehouse</td>

                                            <td class="text-center">
                                                <ul class="flex items-center justify-center gap-2">
                                                    <li>
                                                        <a href="javascript:;" x-tooltip="Edit">
                                                            <svg width="24" height="24" viewBox="0 0 24 24"
                                                                fill="none" xmlns="http://www.w3.org/2000/svg"
                                                                class="h-5 w-5 text-primary">
                                                                <circle opacity="0.5" cx="12" cy="12"
                                                                    r="10" stroke="currentColor" stroke-width="1.5">
                                                                </circle>
                                                                <path d="M8.5 12.5L10.5 14.5L15.5 9.5"
                                                                    stroke="currentColor" stroke-width="1.5"
                                                                    stroke-linecap="round" stroke-linejoin="round">
                                                                </path>
                                                            </svg>
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a href="javascript:;" x-tooltip="Delete">
                                                            <svg width="24" height="24" viewBox="0 0 24 24"
                                                                fill="none" xmlns="http://www.w3.org/2000/svg"
                                                                class="h-5 w-5 text-danger">
                                                                <circle opacity="0.5" cx="12" cy="12"
                                                                    r="10" stroke="currentColor" stroke-width="1.5">
                                                                </circle>
                                                                <path d="M14.5 9.50002L9.5 14.5M9.49998 9.5L14.5 14.5"
                                                                    stroke="currentColor" stroke-width="1.5"
                                                                    stroke-linecap="round">
                                                                </path>
                                                            </svg>
                                                        </a>
                                                    </li>
                                                </ul>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="whitespace-nowrap">105</td>
                                            <td>Olaya Showroom</td>

                                            <td class="text-center">
                                                <ul class="flex items-center justify-center gap-2">
                                                    <li>
                                                        <a href="javascript:;" x-tooltip="Edit">
                                                            <svg width="24" height="24" viewBox="0 0 24 24"
                                                                fill="none" xmlns="http://www.w3.org/2000/svg"
                                                                class="h-5 w-5 text-primary">
                                                                <circle opacity="0.5" cx="12" cy="12"
                                                                    r="10" stroke="currentColor" stroke-width="1.5">
                                                                </circle>
                                                                <path d="M8.5 12.5L10.5 14.5L15.5 9.5"
                                                                    stroke="currentColor" stroke-width="1.5"
                                                                    stroke-linecap="round" stroke-linejoin="round">
                                                                </path>
                                                            </svg>
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a href="javascript:;" x-tooltip="Delete">
                                                            <svg width="24" height="24" viewBox="0 0 24 24"
                                                                fill="none" xmlns="http://www.w3.org/2000/svg"
                                                                class="h-5 w-5 text-danger">
                                                                <circle opacity="0.5" cx="12" cy="12"
                                                                    r="10" stroke="currentColor" stroke-width="1.5">
                                                                </circle>
                                                                <path d="M14.5 9.50002L9.5 14.5M9.49998 9.5L14.5 14.5"
                                                                    stroke="currentColor" stroke-width="1.5"
                                                                    stroke-linecap="round">
                                                                </path>
                                                            </svg>
                                                        </a>
                                                    </li>
                                                </ul>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="whitespace-nowrap">101</td>
                                            <td>Factory Warehouse</td>

                                            <td class="text-center">
                                                <ul class="flex items-center justify-center gap-2">
                                                    <li>
                                                        <a href="javascript:;" x-tooltip="Edit">
                                                            <svg width="24" height="24" viewBox="0 0 24 24"
                                                                fill="none" xmlns="http://www.w3.org/2000/svg"
                                                                class="h-5 w-5 text-primary">
                                                                <circle opacity="0.5" cx="12" cy="12"
                                                                    r="10" stroke="currentColor" stroke-width="1.5">
                                                                </circle>
                                                                <path d="M8.5 12.5L10.5 14.5L15.5 9.5"
                                                                    stroke="currentColor" stroke-width="1.5"
                                                                    stroke-linecap="round" stroke-linejoin="round">
                                                                </path>
                                                            </svg>
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a href="javascript:;" x-tooltip="Delete">
                                                            <svg width="24" height="24" viewBox="0 0 24 24"
                                                                fill="none" xmlns="http://www.w3.org/2000/svg"
                                                                class="h-5 w-5 text-danger">
                                                                <circle opacity="0.5" cx="12" cy="12"
                                                                    r="10" stroke="currentColor" stroke-width="1.5">
                                                                </circle>
                                                                <path d="M14.5 9.50002L9.5 14.5M9.49998 9.5L14.5 14.5"
                                                                    stroke="currentColor" stroke-width="1.5"
                                                                    stroke-linecap="round">
                                                                </path>
                                                            </svg>
                                                        </a>
                                                    </li>
                                                </ul>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="whitespace-nowrap">CERH1</td>
                                            <td>017 - Riyadh</td>

                                            <td class="text-center">
                                                <ul class="flex items-center justify-center gap-2">
                                                    <li>
                                                        <a href="javascript:;" x-tooltip="Edit">
                                                            <svg width="24" height="24" viewBox="0 0 24 24"
                                                                fill="none" xmlns="http://www.w3.org/2000/svg"
                                                                class="h-5 w-5 text-primary">
                                                                <circle opacity="0.5" cx="12" cy="12"
                                                                    r="10" stroke="currentColor" stroke-width="1.5">
                                                                </circle>
                                                                <path d="M8.5 12.5L10.5 14.5L15.5 9.5"
                                                                    stroke="currentColor" stroke-width="1.5"
                                                                    stroke-linecap="round" stroke-linejoin="round">
                                                                </path>
                                                            </svg>
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a href="javascript:;" x-tooltip="Delete">
                                                            <svg width="24" height="24" viewBox="0 0 24 24"
                                                                fill="none" xmlns="http://www.w3.org/2000/svg"
                                                                class="h-5 w-5 text-danger">
                                                                <circle opacity="0.5" cx="12" cy="12"
                                                                    r="10" stroke="currentColor" stroke-width="1.5">
                                                                </circle>
                                                                <path d="M14.5 9.50002L9.5 14.5M9.49998 9.5L14.5 14.5"
                                                                    stroke="currentColor" stroke-width="1.5"
                                                                    stroke-linecap="round">
                                                                </path>
                                                            </svg>
                                                        </a>
                                                    </li>
                                                </ul>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="whitespace-nowrap">WEJE1</td>
                                            <td>002 - Jeddah Warehouse</td>

                                            <td class="text-center">
                                                <ul class="flex items-center justify-center gap-2">
                                                    <li>
                                                        <a href="javascript:;" x-tooltip="Edit">
                                                            <svg width="24" height="24" viewBox="0 0 24 24"
                                                                fill="none" xmlns="http://www.w3.org/2000/svg"
                                                                class="h-5 w-5 text-primary">
                                                                <circle opacity="0.5" cx="12" cy="12"
                                                                    r="10" stroke="currentColor" stroke-width="1.5">
                                                                </circle>
                                                                <path d="M8.5 12.5L10.5 14.5L15.5 9.5"
                                                                    stroke="currentColor" stroke-width="1.5"
                                                                    stroke-linecap="round" stroke-linejoin="round">
                                                                </path>
                                                            </svg>
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a href="javascript:;" x-tooltip="Delete">
                                                            <svg width="24" height="24" viewBox="0 0 24 24"
                                                                fill="none" xmlns="http://www.w3.org/2000/svg"
                                                                class="h-5 w-5 text-danger">
                                                                <circle opacity="0.5" cx="12" cy="12"
                                                                    r="10" stroke="currentColor" stroke-width="1.5">
                                                                </circle>
                                                                <path d="M14.5 9.50002L9.5 14.5M9.49998 9.5L14.5 14.5"
                                                                    stroke="currentColor" stroke-width="1.5"
                                                                    stroke-linecap="round">
                                                                </path>
                                                            </svg>
                                                        </a>
                                                    </li>
                                                </ul>
                                            </td>
                                        </tr>
                                        


                                    </tbody>

                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
