<?php

use App\Http\Controllers\Admin\AdminLoginController;
use App\Http\Controllers\Admin\HomeController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::redirect('/', '/admin/login');

Route::group(['prefix' => 'admin'], function () {
    Route::group(['middleware' => 'admin.guest'], function () {

        Route::get('/login', [AdminLoginController::class, 'index'])->name('admin.login');
        Route::post('/authenticate', [AdminLoginController::class, 'authenticate'])->name('admin.authenticate');

    });
    Route::group(['middleware' => 'admin.auth'], function () {
        Route::get('/dashboard', [HomeController::class, 'index'])->name('admin.dashboard');
        Route::get('/warehouses', [HomeController::class, 'view'])->name('admin.warehouses');
        Route::get('/transfer-request', [HomeController::class, 'transferRequest'])->name('admin.transferRequest');
        Route::get('/transfer-issue', [HomeController::class, 'TIssueQtfDiff'])->name('admin.TIssueQtfDiff');
        Route::get('/transfer-receive', [HomeController::class, 'TRecQtfDiff'])->name('admin.TRecQtfDiff');
        Route::get('/update-onHand', [HomeController::class, 'UpdateOnHand'])->name('admin.UpdateOnHand');
        Route::get('/payment-voucher', [HomeController::class, 'paymentVoucher'])->name('admin.paymentVoucher');
        Route::get('/packing-slip', [HomeController::class, 'PackingSlip'])->name('admin.PackingSlip');
        Route::get('/new-purchase-order', [HomeController::class, 'NewPurchaseOrder'])->name('admin.NewPurchaseOrder');
        Route::get('/purchase-order', [HomeController::class, 'PurchaseOrder'])->name('admin.PurchaseOrder');
        Route::get('/purchase-receive', [HomeController::class, 'PurchaseReceive'])->name('admin.PurchaseReceive');
        Route::get('/production-order-request', [HomeController::class, 'ProductionOrderRequest'])->name('admin.ProductionOrderRequest');
        Route::get('/production-order', [HomeController::class, 'ProductionOrder'])->name('admin.ProductionOrder');
        Route::get('/production-requests', [HomeController::class, 'ProductionRequest'])->name('admin.ProductionRequest');
        Route::get('/add-item', [HomeController::class, 'AddItem'])->name('admin.AddItem');
        Route::get('/item-list', [HomeController::class, 'ItemList'])->name('admin.ItemList');
        Route::get('/customer-management', [HomeController::class, 'CustomerManagement'])->name('admin.CustomerManagement');
        Route::get('/locations', [HomeController::class, 'LocationManage'])->name('admin.LocationManage');
        Route::get('/assets-update', [HomeController::class, 'AssetsUpdate'])->name('admin.AssetsUpdate');
        Route::get('/Invoice-purchase-receive', [HomeController::class, 'InvoicePurchaseReceive'])->name('admin.InvoicePurchaseReceive');
        Route::get('/Invoice-transfer-request', [HomeController::class, 'InvoiceTransferReq'])->name('admin.InvoiceTransferReq');
        Route::get('/update-item-details', [HomeController::class, 'itemDetailsUpdate'])->name('admin.itemDetailsUpdate');

        
        
        
        
        
        Route::get('/logout', [HomeController::class, 'logout'])->name('admin.logout');
        
    });
});

Route::view('/login','admin.login');


